<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute('Notifications')]); ?>
    <main class="w-full mx-auto p-4 pb-24 md:pb-4 bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between mb-8 pb-4">
            <a href="<?php echo e(url()->previous()); ?>" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold text-center flex-1">Notifications</h1>
            <button id="mark-all-read" class="text-sm text-blue-500 hover:text-blue-600">
                Mark All Read
            </button>
        </div>

        <!-- Notifications List -->
        <div class="space-y-4" id="notifications-container">
            <?php $__empty_1 = true; $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="notification-item bg-white dark:bg-gray-800 rounded-lg p-4" data-id="<?php echo e($notification->id); ?>">
                    <div class="flex items-start justify-between">
                        <div class="flex items-start space-x-4">
                            <div class="mt-1">
                                <i class="fas fa-bell <?php echo e($notification->is_read ? 'text-gray-400' : 'text-blue-500'); ?>"></i>
                            </div>
                            <div>
                                <h2 class="font-semibold mb-1"><?php echo e($notification->title); ?></h2>
                                <p class="text-sm text-gray-600 dark:text-gray-400">
                                    <?php echo e($notification->message); ?>

                                </p>
                                <span class="text-xs text-gray-500 mt-1">
                                    <?php echo e($notification->created_at->diffForHumans()); ?>

                                </span>
                            </div>
                        </div>
                        <div class="flex items-center space-x-2">
                            <?php if(!$notification->is_read): ?>
                                <button class="mark-read text-gray-500 hover:text-blue-600" data-id="<?php echo e($notification->id); ?>">
                                    <i class="fas fa-eye"></i>
                                </button>
                            <?php endif; ?>
                            <button class="delete-notification text-gray-500 hover:text-red-600" data-id="<?php echo e($notification->id); ?>">
                                <i class="fas fa-trash"></i>
                            </button>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center py-8">
                    <div class="w-16 h-16 bg-gray-200 dark:bg-gray-800 rounded-full flex items-center justify-center mx-auto mb-4">
                        <i class="fas fa-bell-slash text-gray-400 dark:text-gray-600 text-2xl"></i>
                    </div>
                    <p class="text-gray-500 dark:text-gray-400">No notifications yet</p>
                </div>
            <?php endif; ?>

            <!-- Pagination -->
            <div class="mt-4">
                <?php echo e($notifications->links()); ?>

            </div>
        </div>
    </main>

    <?php $__env->startPush('scripts'); ?>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // Mark single notification as read
        document.querySelectorAll('.mark-read').forEach(button => {
            button.addEventListener('click', function() {
                const notificationId = this.getAttribute('data-id');
                
                fetch(`/notifications/${notificationId}/read`, {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Content-Type': 'application/json'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const notificationItem = this.closest('.notification-item');
                        notificationItem.querySelector('.fas.fa-bell').classList.remove('text-blue-500');
                        notificationItem.querySelector('.fas.fa-bell').classList.add('text-gray-400');
                        this.remove();
                    }
                });
            });
        });

        // Delete notification
        document.querySelectorAll('.delete-notification').forEach(button => {
            button.addEventListener('click', function() {
                const notificationId = this.getAttribute('data-id');
                
                fetch(`/notifications/${notificationId}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Content-Type': 'application/json'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const notificationItem = this.closest('.notification-item');
                        notificationItem.remove();
                    }
                });
            });
        });

        // Mark all notifications as read
        document.getElementById('mark-all-read')?.addEventListener('click', function() {
            fetch('/notifications/mark-all-read', {
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                    'Content-Type': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    document.querySelectorAll('.notification-item').forEach(item => {
                        item.querySelector('.fas.fa-bell').classList.remove('text-blue-500');
                        item.querySelector('.fas.fa-bell').classList.add('text-gray-400');
                        item.querySelector('.mark-read')?.remove();
                    });
                }
            });
        });
    });
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?><?php /**PATH /home/hyipcode/public_html/resources/views/user/notifications.blade.php ENDPATH**/ ?>