<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="min-h-screen bg-gray-100 dark:bg-gray-900">
        <div class="container px-6 mx-auto">
            <div class="flex justify-between items-center my-6">
                <h2 class="text-2xl font-semibold text-gray-700 dark:text-gray-200">Staking Plans</h2>
            </div>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-8">
                <?php $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="relative bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-6 flex flex-col justify-between border border-gray-100 dark:border-gray-700 hover:shadow-xl transition-shadow">
                        <div class="flex items-center mb-4">
                            <?php if($plan->coin && $plan->coin->image): ?>
                                <img src="<?php echo e($plan->coin->image_url); ?>" alt="<?php echo e($plan->coin->display_symbol); ?>" class="h-10 w-10 rounded-full border-2 border-purple-500 shadow-sm mr-3 bg-white dark:bg-gray-900">
                            <?php else: ?>
                                <div class="h-10 w-10 rounded-full bg-purple-100 flex items-center justify-center mr-3">
                                    <i class="fas fa-layer-group text-purple-600 text-xl"></i>
                                </div>
                            <?php endif; ?>
                            <div>
                                <div class="text-lg font-bold text-gray-900 dark:text-gray-100 flex items-center">
                                    <?php echo e($plan->name); ?>

                                    <span class="ml-2 px-2 py-1 text-xs rounded-full <?php echo e($plan->is_active ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200'); ?>">
                                        <?php echo e($plan->is_active ? 'Active' : 'Inactive'); ?>

                                    </span>
                                </div>
                                <div class="text-xs text-gray-500 dark:text-gray-400 mt-1"><?php echo e($plan->description); ?></div>
                            </div>
                        </div>
                        <div class="grid grid-cols-2 gap-2 mb-4">
                            <div class="rounded-lg bg-purple-50 dark:bg-purple-900 p-3 flex flex-col items-center">
                                <span class="text-xs text-gray-500 dark:text-gray-400">Coin</span>
                                <span class="font-semibold text-purple-700 dark:text-purple-300"><?php echo e($plan->coin->display_symbol ?? '-'); ?></span>
                            </div>
                            <div class="rounded-lg bg-green-50 dark:bg-green-900 p-3 flex flex-col items-center">
                                <span class="text-xs text-gray-500 dark:text-gray-400">ROI</span>
                                <span class="font-semibold text-green-700 dark:text-green-300"><?php echo e(number_format($plan->return_of_interest, 1)); ?>% (<?php echo e(ucfirst($plan->interest_type)); ?>)</span>
                            </div>
                            <div class="rounded-lg bg-blue-50 dark:bg-blue-900 p-3 flex flex-col items-center">
                                <span class="text-xs text-gray-500 dark:text-gray-400">Lock</span>
                                <span class="font-semibold text-blue-700 dark:text-blue-300"><?php echo e($plan->lock_duration); ?> days</span>
                            </div>
                            <div class="rounded-lg bg-yellow-50 dark:bg-yellow-900 p-3 flex flex-col items-center">
                                <span class="text-xs text-gray-500 dark:text-gray-400">Min/Max</span>
                                <span class="font-semibold text-yellow-700 dark:text-yellow-300"><?php echo e(number_format($plan->min_amount, 2)); ?> - <?php echo e(number_format($plan->max_amount, 2)); ?></span>
                            </div>
                        </div>
                        <div class="mt-2 flex justify-end">
                            <a href="<?php echo e(route('staking.show', $plan)); ?>" class="px-5 py-2 text-sm font-medium text-white bg-purple-600 rounded-lg hover:bg-purple-700 shadow-md transition">Stake Now</a>
                        </div>
                        <div class="absolute top-0 right-0 h-2 w-2 rounded-tr-2xl rounded-bl-2xl bg-purple-500"></div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="my-8">
                <h3 class="text-xl font-semibold mb-4 text-gray-800 dark:text-gray-200">My Stakes</h3>
                <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md overflow-x-auto">
                    <table class="w-full whitespace-no-wrap">
                        <thead>
                            <tr class="text-xs font-semibold tracking-wide text-left text-gray-500 dark:text-gray-400 uppercase bg-gray-50 dark:bg-gray-700 border-b dark:border-gray-600">
                                <th class="px-4 py-3">Plan</th>
                                <th class="px-4 py-3">Amount</th>
                                <th class="px-4 py-3">Start</th>
                                <th class="px-4 py-3">End</th>
                                <th class="px-4 py-3">Status</th>
                                <th class="px-4 py-3">Profit</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white dark:bg-gray-800 divide-y divide-gray-200 dark:divide-gray-700">
                            <?php $__empty_1 = true; $__currentLoopData = $userStakes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stake): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr class="text-gray-700 dark:text-gray-200">
                                    <td class="px-4 py-3"><?php echo e($stake->stakingPlan->name ?? '-'); ?></td>
                                    <td class="px-4 py-3"><?php echo e(number_format($stake->amount, 8)); ?> <?php echo e($stake->stakingPlan->coin->display_symbol ?? ''); ?></td>
                                    <td class="px-4 py-3">
                                        <?php echo e($stake->start_time ? (\Illuminate\Support\Carbon::parse($stake->start_time)->format('M d, Y H:i')) : '-'); ?>

                                    </td>
                                    <td class="px-4 py-3">
                                        <?php echo e($stake->end_time ? (\Illuminate\Support\Carbon::parse($stake->end_time)->format('M d, Y H:i')) : '-'); ?>

                                    </td>
                                    <td class="px-4 py-3">
                                        <span class="px-2 py-1 text-xs rounded-full <?php echo e($stake->status == 'active' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : ($stake->status == 'completed' ? 'bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200' : 'bg-gray-100 text-gray-600 dark:bg-gray-700 dark:text-gray-300')); ?>">
                                            <?php echo e(ucfirst($stake->status)); ?>

                                        </span>
                                    </td>
                                    <td class="px-4 py-3"><?php echo e(number_format($stake->profit_earned, 8)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="6" class="px-4 py-8 text-center text-gray-500 dark:text-gray-400">
                                        You have no active stakes
                                    </td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?> <?php /**PATH /home/hyipcode/public_html/resources/views/user/staking/index.blade.php ENDPATH**/ ?>