<!-- Modern Progress Modal -->
<div id="progressModal" class="fixed inset-0 bg-black bg-opacity-75 hidden z-50 flex items-center justify-center">
    <div class="bg-white dark:bg-gray-900 w-full max-w-md mx-4 p-8 rounded-xl shadow-2xl">
        <div class="text-center mb-6">
            <!-- Animated Icon -->
            <div class="w-16 h-16 mx-auto mb-4 relative">
                <div class="absolute inset-0 rounded-full border-4 border-yellow-200 dark:border-yellow-800"></div>
                <div id="spinnerRing" class="absolute inset-0 rounded-full border-4 border-transparent border-t-yellow-500 animate-spin"></div>
                <div class="absolute inset-2 rounded-full bg-yellow-50 dark:bg-yellow-900/20 flex items-center justify-center">
                    <i class="fas fa-paper-plane text-yellow-600 text-xl"></i>
                </div>
            </div>
            
            <h3 class="text-xl font-bold mb-2 text-gray-800 dark:text-white">Processing Transaction</h3>
            <p class="text-sm text-gray-600 dark:text-gray-400">Please wait while we securely process your transfer...</p>
        </div>
        
        <!-- Modern Progress Bar -->
        <div class="mb-6">
            <!-- Progress Steps -->
            <div class="flex justify-between mb-4 text-xs">
                <span id="step1" class="flex items-center text-yellow-600">
                    <div class="w-2 h-2 rounded-full bg-yellow-500 mr-1"></div>
                    Validating
                </span>
                <span id="step2" class="flex items-center text-gray-400">
                    <div class="w-2 h-2 rounded-full bg-gray-300 mr-1"></div>
                    Processing
                </span>
                <span id="step3" class="flex items-center text-gray-400">
                    <div class="w-2 h-2 rounded-full bg-gray-300 mr-1"></div>
                    Broadcasting
                </span>
                <span id="step4" class="flex items-center text-gray-400">
                    <div class="w-2 h-2 rounded-full bg-gray-300 mr-1"></div>
                    Complete
                </span>
            </div>
            
            <!-- Animated Progress Bar -->
            <div class="relative">
                <div class="overflow-hidden h-3 mb-4 text-xs flex rounded-full bg-gray-200 dark:bg-gray-700">
                    <div id="progressBar" 
                         class="transition-all duration-1000 ease-out shadow-sm flex flex-col text-center whitespace-nowrap text-white justify-center bg-gradient-to-r from-yellow-400 to-yellow-500 rounded-full relative"
                         style="width: 0%">
                        <!-- Shimmer effect -->
                        <div class="absolute inset-0 bg-gradient-to-r from-transparent via-white/30 to-transparent animate-pulse rounded-full"></div>
                    </div>
                </div>
                
                <!-- Progress percentage -->
                <div class="flex justify-between items-center">
                    <span id="progressText" class="text-sm font-bold text-yellow-600">0%</span>
                    <span id="progressTime" class="text-xs text-gray-500">Estimated: 3-5 seconds</span>
                </div>
            </div>
            
            <!-- Status Messages -->
            <div class="mt-4 text-center">
                <p id="progressStatus" class="text-sm text-gray-600 dark:text-gray-400 font-medium">Initializing secure transfer...</p>
                <p id="progressSubStatus" class="text-xs text-gray-500 dark:text-gray-500 mt-1">Preparing transaction data</p>
            </div>
        </div>
        
        <!-- Security Notice -->
        <div class="bg-blue-50 dark:bg-blue-900/30 border border-blue-200 dark:border-blue-800 rounded-lg p-3">
            <div class="flex items-start">
                <i class="fas fa-shield-alt text-blue-500 text-sm mt-0.5 mr-2"></i>
                <div>
                    <p class="text-xs text-blue-700 dark:text-blue-300 font-medium">Secure Transfer</p>
                    <p class="text-xs text-blue-600 dark:text-blue-400">Your transaction is protected by industry-standard encryption</p>
                </div>
            </div>
        </div>
    </div>
</div>