<x-user-layout>
    <div class="min-h-screen bg-gray-100 dark:bg-gray-900 flex items-center justify-center">
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-8 max-w-md w-full border border-gray-100 dark:border-gray-700">
            <div class="flex flex-col items-center">
                <div class="mb-4">
                    @if($userStake->stakingPlan->coin && $userStake->stakingPlan->coin->image)
                        <img src="{{ $userStake->stakingPlan->coin->image_url }}" alt="{{ $userStake->stakingPlan->coin->display_symbol }}" class="h-14 w-14 rounded-full border-2 border-purple-500 shadow-sm bg-white dark:bg-gray-900">
                    @else
                        <div class="h-14 w-14 rounded-full bg-purple-100 flex items-center justify-center">
                            <i class="fas fa-layer-group text-purple-600 text-2xl"></i>
                        </div>
                    @endif
                </div>
                <div class="mb-2">
                    <svg class="w-16 h-16 text-green-500" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2l4-4m6 2a9 9 0 11-18 0a9 9 0 0118 0z" />
                    </svg>
                </div>
                <h2 class="text-2xl font-bold text-gray-800 dark:text-gray-100 mb-2">Staking Successful!</h2>
                <div class="text-gray-600 dark:text-gray-300 mb-6 text-center">
                    You have successfully staked <span class="font-semibold">{{ number_format($userStake->amount, 0) }} {{ $userStake->stakingPlan->coin->display_symbol }}</span> in <span class="font-semibold">{{ $userStake->stakingPlan->name }}</span>.<br>
                    Your stake will be locked for <span class="font-semibold">{{ $userStake->stakingPlan->lock_duration }} days</span>.
                </div>
                <div class="w-full grid grid-cols-2 gap-3 mb-4">
                    <div class="rounded-lg bg-purple-50 dark:bg-purple-900 p-3 flex flex-col items-center">
                        <span class="text-xs text-gray-500 dark:text-gray-400">Start</span>
                        <span class="font-semibold text-purple-700 dark:text-purple-300">
                            {{ $userStake->start_time ? (\Illuminate\Support\Carbon::parse($userStake->start_time)->format('M d, Y H:i')) : '-' }}
                        </span>
                    </div>
                    <div class="rounded-lg bg-blue-50 dark:bg-blue-900 p-3 flex flex-col items-center">
                        <span class="text-xs text-gray-500 dark:text-gray-400">End</span>
                        <span class="font-semibold text-blue-700 dark:text-blue-300">
                            {{ $userStake->end_time ? (\Illuminate\Support\Carbon::parse($userStake->end_time)->format('M d, Y H:i')) : '-' }}
                        </span>
                    </div>
                    <div class="rounded-lg bg-green-50 dark:bg-green-900 p-3 flex flex-col items-center col-span-2">
                        <span class="text-xs text-gray-500 dark:text-gray-400">ROI</span>
                        <span class="font-semibold text-green-700 dark:text-green-300">{{ number_format($userStake->stakingPlan->return_of_interest, 1) }}% ({{ ucfirst($userStake->stakingPlan->interest_type) }})</span>
                    </div>
                </div>
                <a href="{{ route('staking') }}" class="mt-4 px-6 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 shadow-md">Back to Staking Plans</a>
            </div>
        </div>
    </div>
</x-user-layout> 