<x-user-layout>
    <div class="min-h-screen bg-gray-100 dark:bg-gray-900">
        <div class="container px-6 mx-auto py-8">
            <div class="mb-6">
                <a href="{{ route('staking') }}" class="text-purple-600 hover:underline dark:text-purple-400">&larr; Back to Staking Plans</a>
            </div>
            <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-8 mb-8 border border-gray-100 dark:border-gray-700 flex flex-col md:flex-row md:items-center md:space-x-8">
                <div class="flex-shrink-0 flex flex-col items-center mb-6 md:mb-0">
                    @if($stakingPlan->coin && $stakingPlan->coin->image)
                        <img src="{{ $stakingPlan->coin->image_url }}" alt="{{ $stakingPlan->coin->display_symbol }}" class="h-16 w-16 rounded-full border-2 border-purple-500 shadow-sm bg-white dark:bg-gray-900">
                    @else
                        <div class="h-16 w-16 rounded-full bg-purple-100 flex items-center justify-center">
                            <i class="fas fa-layer-group text-purple-600 text-2xl"></i>
                        </div>
                    @endif
                    <span class="mt-2 px-2 py-1 text-xs rounded-full {{ $stakingPlan->is_active ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200' }}">
                        {{ $stakingPlan->is_active ? 'Active' : 'Inactive' }}
                    </span>
                </div>
                <div class="flex-1">
                    <h2 class="text-2xl font-bold text-gray-800 dark:text-gray-100 mb-2">{{ $stakingPlan->name }}</h2>
                    <div class="mb-2 text-gray-500 dark:text-gray-400">{{ $stakingPlan->description }}</div>
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mt-4">
                        <div class="rounded-lg bg-purple-50 dark:bg-purple-900 p-3 flex flex-col items-center">
                            <span class="text-xs text-gray-500 dark:text-gray-400">Coin</span>
                            <span class="font-semibold text-purple-700 dark:text-purple-300">{{ $stakingPlan->coin->display_symbol ?? '-' }}</span>
                        </div>
                        <div class="rounded-lg bg-green-50 dark:bg-green-900 p-3 flex flex-col items-center">
                            <span class="text-xs text-gray-500 dark:text-gray-400">ROI</span>
                            <span class="font-semibold text-green-700 dark:text-green-300">{{ number_format($stakingPlan->return_of_interest, 1) }}% ({{ ucfirst($stakingPlan->interest_type) }})</span>
                        </div>
                        <div class="rounded-lg bg-blue-50 dark:bg-blue-900 p-3 flex flex-col items-center">
                            <span class="text-xs text-gray-500 dark:text-gray-400">Lock</span>
                            <span class="font-semibold text-blue-700 dark:text-blue-300">{{ $stakingPlan->lock_duration }} days</span>
                        </div>
                        <div class="rounded-lg bg-yellow-50 dark:bg-yellow-900 p-3 flex flex-col items-center">
                            <span class="text-xs text-gray-500 dark:text-gray-400">Min/Max</span>
                            <span class="font-semibold text-yellow-700 dark:text-yellow-300">{{ number_format($stakingPlan->min_amount, 2) }} - {{ number_format($stakingPlan->max_amount, 2) }}</span>
                        </div>
                    </div>
                    <div class="mt-4 text-sm"><span class="font-medium text-gray-700 dark:text-gray-300">Your Balance:</span> <span class="text-gray-900 dark:text-gray-100">{{ number_format($balance, 8) }} {{ $stakingPlan->coin->display_symbol }}</span></div>
                    @if($userStake)
                        <div class="mt-2 text-sm text-green-600 dark:text-green-400">You have an active stake in this plan.</div>
                    @endif
                </div>
            </div>
            <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-8 border border-gray-100 dark:border-gray-700">
                <h3 class="text-lg font-semibold text-gray-800 dark:text-gray-100 mb-4">Stake Now</h3>
                @if($userStake)
                    <div class="text-sm text-gray-500 dark:text-gray-400 mb-2">You already have an active stake in this plan.</div>
                @else
                    <form action="{{ route('staking.stake', $stakingPlan) }}" method="POST" class="space-y-4">
                        @csrf
                        <div>
                            <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">Amount ({{ $stakingPlan->coin->display_symbol }})</label>
                            <input type="number" name="amount" step="0.00000001" min="{{ $stakingPlan->min_amount }}" max="{{ $stakingPlan->max_amount }}" value="{{ old('amount') }}" required class="w-full px-3 py-2 border border-gray-300 dark:border-gray-600 rounded-lg bg-white dark:bg-gray-700 text-gray-900 dark:text-gray-100">
                            @error('amount')
                                <div class="text-red-600 dark:text-red-400 text-xs mt-1">{{ $message }}</div>
                            @enderror
                        </div>
                        @error('error')
                            <div class="text-red-600 dark:text-red-400 text-xs mt-1">{{ $message }}</div>
                        @enderror
                        <div class="flex justify-end">
                            <button type="submit" class="px-6 py-2 text-sm font-medium text-white bg-purple-600 rounded-lg hover:bg-purple-700 shadow-md transition">Stake Now</button>
                        </div>
                    </form>
                @endif
            </div>
        </div>
    </div>
</x-user-layout> 