<x-user-layout>
    <main class="w-full mx-auto min-h-screen bg-gradient-to-b from-gray-950 via-gray-900 to-black text-gray-100 transition-all duration-500 flex flex-col relative overflow-hidden">
        <!-- Subtle gradient lines background -->
        <div class="absolute inset-0 bg-[radial-gradient(circle_at_30%_30%,rgba(255,255,255,0.05),transparent_40%),radial-gradient(circle_at_70%_70%,rgba(255,215,0,0.05),transparent_40%)]"></div>

        <!-- Header -->
        <div class="flex items-center justify-between p-4 border-b border-gray-800 backdrop-blur-lg bg-white/5 relative z-10">
            <a href="{{ route('dashboard') }}" class="text-gray-400 hover:text-yellow-400 transition">
                <i class="fas fa-times text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold tracking-wide">Transaction Details</h1>
            <div class="w-8"></div>
        </div>

        <!-- Main Content -->
        <div class="flex-grow flex flex-col items-center justify-center p-4 space-y-6 relative z-10">

            {{-- Transaction Status Icons --}}
            @if($transaction->status === App\Models\Transaction::STATUS_PENDING)
                <!-- Animated Pending Icon -->
                <div class="relative flex items-center justify-center">
                    <div class="w-28 h-28 rounded-full bg-gradient-to-tr from-yellow-400 via-yellow-500 to-amber-600 
                                animate-spin-slow border-4 border-transparent bg-clip-padding opacity-90 shadow-lg shadow-yellow-500/30"></div>
                    <div class="absolute w-20 h-20 rounded-full bg-gray-900 flex items-center justify-center shadow-inner">
                        <i class="fas fa-hourglass-half text-4xl text-yellow-400 animate-pulse"></i>
                    </div>
                </div>

                <h2 class="text-3xl font-bold text-center text-yellow-400 tracking-wide">Transaction Pending</h2>
                <p class="text-gray-400 text-center">Your transaction is being securely processed on the blockchain.</p>

            @elseif($transaction->status === App\Models\Transaction::STATUS_COMPLETED)
                <div class="w-24 h-24 bg-green-500 rounded-full flex items-center justify-center animate-pop">
                    <i class="fas fa-check text-4xl text-white"></i>
                </div>
                <h2 class="text-3xl font-bold text-center text-green-400">Transaction Successful!</h2>
                <p class="text-gray-400 text-center">Your funds have been sent successfully.</p>

            @elseif($transaction->status === App\Models\Transaction::STATUS_FAILED)
                <div class="w-24 h-24 bg-red-500 rounded-full flex items-center justify-center animate-shake">
                    <i class="fas fa-times text-4xl text-white"></i>
                </div>
                <h2 class="text-3xl font-bold text-center text-red-400">Transaction Failed</h2>
                <p class="text-gray-400 text-center">There was an issue processing your transaction.</p>
            @else
                <div class="w-24 h-24 bg-gray-500 rounded-full flex items-center justify-center">
                    <i class="fas fa-question text-4xl text-white"></i>
                </div>
                <h2 class="text-2xl font-bold text-center">Transaction Status Unknown</h2>
                <p class="text-gray-400 text-center">Please contact support for more information.</p>
            @endif

            {{-- Transaction Details Card --}}
            <div class="w-full max-w-md bg-white/5 backdrop-blur-xl border border-gray-800/50 rounded-2xl p-6 space-y-4 shadow-xl shadow-black/40">
                @php
                    $symbol = $transaction->fromCoin->display_symbol ?? $transaction->fromCoin->symbol ?? strtoupper($transaction->which_crypto);
                    $amount = $transaction->amount_out ?? $transaction->amount_in ?? 0;
                    $fee = $transaction->network_fee ?? $transaction->metadata['network_fee'] ?? 0;
                    $total = $amount + $fee;
                @endphp

                <div class="flex justify-between">
                    <span class="text-gray-400">Amount Sent</span>
                    <span class="font-semibold text-yellow-400">
                        {{ number_format($amount, 8) }} {{ $symbol }}
                    </span>
                </div>

                <div class="flex justify-between">
                    <span class="text-gray-400">Recipient Address</span>
                    <span class="font-semibold text-gray-200 truncate max-w-[60%] text-right">
                        {{ $transaction->metadata['external_address'] ?? 'N/A' }}
                    </span>
                </div>

                <div class="flex justify-between">
                    <span class="text-gray-400">Network Fee</span>
                    <span class="font-semibold">
                        {{ $fee > 0 ? number_format($fee, 8) . ' ' . $symbol : 'Free' }}
                    </span>
                </div>

                <div class="flex justify-between font-semibold border-t border-gray-700 pt-2">
                    <span>Total</span>
                    <span class="text-yellow-400">
                        {{ number_format($total, 8) }} {{ $symbol }}
                    </span>
                </div>

                <div class="flex justify-between">
                    <span class="text-gray-400">Date</span>
                    <span class="font-semibold">{{ $transaction->created_at->format('M d, Y H:i:s') }}</span>
                </div>

                @if(isset($transaction->metadata['transaction_hash']))
                <div class="flex justify-between items-center">
                    <span class="text-gray-400">Transaction Hash</span>
                    <div class="flex items-center gap-2">
                        <span class="font-semibold text-xs text-gray-300 truncate max-w-[130px]">
                            {{ substr($transaction->metadata['transaction_hash'], 0, 8) . '...' . substr($transaction->metadata['transaction_hash'], -6) }}
                        </span>
                        <button onclick="copyToClipboard('{{ $transaction->metadata['transaction_hash'] }}')" class="text-yellow-500 hover:text-yellow-400 text-sm">
                            <i class="far fa-copy"></i>
                        </button>
                    </div>
                </div>
                @endif
            </div>
        </div>

        <!-- Done Button -->
        <div class="p-4 relative z-10">
            <a href="{{ route('dashboard') }}" 
               class="block w-full bg-yellow-500 hover:bg-yellow-600 text-black font-semibold py-3 px-4 rounded-xl transition-transform transform hover:scale-[1.02] text-center shadow-md shadow-yellow-500/30">
                Done
            </a>
        </div>
    </main>

    <style>
        /* Slow spin animation */
        @keyframes spin-slow {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .animate-spin-slow {
            animation: spin-slow 3s linear infinite;
        }

        /* Pop in success animation */
        @keyframes pop {
            0% { transform: scale(0.8); opacity: 0; }
            60% { transform: scale(1.1); opacity: 1; }
            100% { transform: scale(1); }
        }
        .animate-pop {
            animation: pop 0.6s ease-in-out;
        }

        /* Shake for failed */
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-5px); }
            75% { transform: translateX(5px); }
        }
        .animate-shake {
            animation: shake 0.5s ease-in-out;
        }
    </style>

    <script>
        function copyToClipboard(text) {
            navigator.clipboard.writeText(text).then(() => {
                const msg = document.createElement('div');
                msg.className = 'fixed bottom-4 right-4 bg-green-500 text-white px-4 py-2 rounded shadow-lg text-sm';
                msg.textContent = 'Copied to clipboard!';
                document.body.appendChild(msg);
                setTimeout(() => msg.remove(), 2000);
            }).catch(() => {
                const msg = document.createElement('div');
                msg.className = 'fixed bottom-4 right-4 bg-red-500 text-white px-4 py-2 rounded shadow-lg text-sm';
                msg.textContent = 'Failed to copy';
                document.body.appendChild(msg);
                setTimeout(() => msg.remove(), 2000);
            });
        }
    </script>
</x-user-layout>
