<x-user-layout>
   <main class="w-full mx-auto h-auto bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
       <!-- Header -->
       <div class="flex items-center justify-between p-4">
           <button wire:navigate href="{{ route('receive.payid') }}" class="text-gray-400 hover:text-gray-300">
               <i class="fas fa-arrow-left text-xl"></i>
           </button>
           <h1 class="text-xl font-semibold">Receive {{ $asset['name'] }}</h1>
           <div class="w-8"></div>
       </div>

       <!-- Main Content -->
       <div class="p-4 space-y-8">
           <!-- Warning Banner -->
           <div class="bg-yellow-900/20 border border-yellow-500/20 rounded-lg p-4">
               <div class="flex items-center space-x-2">
                   <i class="fas fa-info-circle text-yellow-500"></i>
                   <p class="text-yellow-500 text-sm">
                       Only send {{ $asset['symbol'] }} {{ $asset['network'] ? '(' . $asset['network'] . ')' : '' }} assets from a Ledger Chain Pay ID to your Ledger Chain Pay ID.
                   </p>
               </div>
           </div>

           <!-- Pay ID Section -->
           <div class="flex items-center justify-center space-x-2">
               <div class="relative">
                   @if($asset['icon_url'])
                       <img src="{{ $asset['icon_url'] }}" alt="{{ $asset['symbol'] }}" class="w-8 h-8 rounded-full">
                       @if(!empty($asset['network_url']))
                           <img src="{{ $asset['network_url'] }}" 
                               alt="{{ $asset['network'] }}" 
                               class="absolute border border-light" 
                               style="width: 12px; height: auto; bottom: 0; right: 0; background: white; border-radius: 50%;">
                       @endif
                   @else
                       <div class="w-8 h-8 bg-yellow-500 rounded-full flex items-center justify-center">
                           <i class="fas fa-shield-alt text-black text-sm"></i>
                       </div>
                   @endif
               </div>
               <span class="text-lg">{{ $asset['symbol'] }}</span>
               @if($asset['network'])
                   <span class="bg-white dark:bg-gray-800 text-sm px-2 py-1 rounded">{{ $asset['network'] }}</span>
               @endif
           </div>

           <!-- QR Code Container -->
           <div class="flex flex-col items-center space-y-4">
               <div class="relative">
                   <div class="bg-white dark:bg-gray-800 p-4 rounded-lg">
                       <div id="qrcode" class="w-64 h-64 relative">
                           <!-- QR code will be generated here -->
                           <div id="qrCanvas"></div>
                           <!-- Centered logo overlay -->
                           <div class="absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2">
                               <div class="w-12 h-12 bg-yellow-500 rounded-full flex items-center justify-center">
                                <i class="fas fa-shield-alt text-black text-xl"></i>
                            </div>
                           </div>
                       </div>
                   </div>
               </div>
               <!-- Pay ID Text -->
               <p class="text-lg font-mono select-all" id="payId">{{ $user->uuid }}</p>
           </div>

           <!-- Action Buttons -->
           <div class="flex justify-center space-x-12 pt-4">
               <!-- Copy Button -->
               <button onclick="copyPayId()" class="flex flex-col items-center space-y-2 text-gray-400 hover:text-gray-300">
                   <div class="w-12 h-12 bg-white dark:bg-gray-800 rounded-full flex items-center justify-center">
                       <i class="far fa-copy text-xl"></i>
                   </div>
                   <span class="text-sm">Copy</span>
               </button>

               <!-- Share Button -->
               <button onclick="sharePayId()" class="flex flex-col items-center space-y-2 text-gray-400 hover:text-gray-300">
                   <div class="w-12 h-12 bg-white dark:bg-gray-800 rounded-full flex items-center justify-center">
                       <i class="fab fa-whatsapp text-xl"></i>
                   </div>
                   <span class="text-sm">Share</span>
               </button>
           </div>
            <!-- Copy Success Message -->
               <div id="copyMessage" class="fixed top-20 right-4 bg-green-500 text-white px-4 py-2 rounded-lg transform translate-y-[-100%] opacity-0 transition-all duration-300">
               PayID copied to clipboard
           </div>
       </div>
   </main>

   @push('scripts')
   <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
   <script>
       document.addEventListener('DOMContentLoaded', function() {
           const qrData = {
               payId: '{{ $user->uuid }}',
               symbol: '{{ $asset["symbol"] }}',
               network: '{{ $asset["network"] ?? "native" }}',
               type: 'LC_PAYMENT'
           };

           new QRCode(document.getElementById("qrCanvas"), {
               text: JSON.stringify(qrData),
               width: 256,
               height: 256,
               colorDark: document.querySelector('html').classList.contains('dark') ? "#FFFFFF" : "#000000",
               colorLight: document.querySelector('html').classList.contains('dark') ? "#1F2937" : "#FFFFFF",
               correctLevel: QRCode.CorrectLevel.H
           });
       });

       function copyPayId() {
           const payId = document.getElementById('payId').textContent;
           navigator.clipboard.writeText(payId)
               .then(() => {
                   const message = document.getElementById('copyMessage');
                   message.style.transform = 'translate(0, 0)';
                   message.style.opacity = '1';
                   
                   setTimeout(() => {
                       message.style.transform = 'translate(0, -100%)';
                       message.style.opacity = '0';
                   }, 2000);
               })
               .catch(err => {
                   console.error('Failed to copy text: ', err);
               });
       }

       function sharePayId() {
           const payId = document.getElementById('payId').textContent;
           const shareText = `My Defibit PayID for ${@json($asset['symbol'])}${@json($asset['network']) ? ' (' + @json($asset['network']) + ')' : ''}: ${payId}`;
           const shareUrl = `https://wa.me/?text=${encodeURIComponent(shareText)}`;
           window.open(shareUrl, '_blank');
       }
   </script>
   @endpush
</x-user-layout>