<x-user-layout>
    <main class="w-full mx-auto p-4 pb-24 md:pb-4 bg-gray-100 text-gray-900 dark:bg-gray-900 dark:text-white transition-all duration-300">
        <!-- Header -->
        <div class="flex items-center justify-between mb-8 pb-4">
            <a href="{{ route('dashboard') }}" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                <i class="fas fa-arrow-left text-xl"></i>
            </a>
            <h1 class="text-xl font-semibold text-center flex-1">KYC Verification</h1>
            <div class="w-8"></div> <!-- Spacer for centering -->
        </div>
        @if(session('error'))
            <div class="bg-red-500 bg-opacity-10 border border-red-500 mb-4 text-red-500 px-4 py-3 rounded relative" role="alert">
                <p class="text-sm">{{ session('error') }}</p>
            </div>
            @endif
        <!-- Dynamic Info Banner -->
        <div id="kyc-info-banner" class="bg-yellow-900/20 border border-yellow-500/20 rounded-lg p-4 mb-8 
             {{ auth()->user()->kyc_status !== 'not_submitted' ? 'hidden' : '' }}">
            <p class="text-yellow-500 text-center">Upload your documents to verify your account.</p>
        </div>
        <div id="kyc-reject-banner" class="bg-red-900/20 border border-red-500/20 rounded-lg p-4 mb-8 
             {{ auth()->user()->kyc_status !== 'rejected' ? 'hidden' : '' }}">
            <p class="text-red-500 text-center">KYC Rejected. Please reupload your documents.</p>
        </div>

        <!-- Pending State -->
        <div id="kyc-pending-banner" class="bg-blue-900/20 border border-blue-500/20 rounded-lg p-4 mb-8 
            {{ auth()->user()->kyc_status !== 'pending' ? 'hidden' : '' }}">
            <div class="flex items-center justify-center">
                <i class="fas fa-clock text-blue-500 mr-2"></i>
                <p class="text-blue-500">Your documents are under review. Verification pending...</p>
            </div>
            <div class="mt-4 text-center text-sm text-gray-400">
                Submitted on: {{ auth()->user()->updated_at->format('M d, Y H:i') }}
            </div>
        </div>

        <!-- Approved State -->
        <div id="kyc-approved-banner" class="bg-green-900/20 border border-green-500/20 rounded-lg p-4 mb-8 
            {{ auth()->user()->kyc_status !== 'approved' ? 'hidden' : '' }}">
            <div class="flex items-center justify-center">
                <i class="fas fa-check-circle text-green-500 mr-2"></i>
                <p class="text-green-500">Your account has been verified successfully!</p>
            </div>
            <div class="mt-4 text-center text-sm text-gray-400">
                Verified on: {{ auth()->user()->updated_at->format('M d, Y H:i') }}
            </div>
        </div>

        <!-- Document Upload Form -->
        <form id="kyc-form" method="POST" action="{{ route('user.kyc.upload') }}" 
              enctype="multipart/form-data"
              class="{{ in_array(auth()->user()->kyc_status, ['pending', 'approved']) ? 'hidden' : '' }}">
            @csrf
            <!-- Document Upload Sections -->
            <div class="space-y-8">
                <!-- ID Front Section -->
                <div class="space-y-2" id="front-id-section">
                    <h2 class="text-lg font-semibold">ID (front)</h2>
                    <p class="text-sm text-gray-400">This can be a photo of the front of your: Driving license, National identity card, Passport, Birth certificate.</p>
                    
                    <!-- Upload Box -->
                    <div class="relative border-2 border-dashed border-gray-700 rounded-lg p-8 text-center cursor-pointer hover:border-gray-600 transition-colors">
                        <input type="file" class="hidden" id="front_id" name="front_id" accept=".jpg,.jpeg,.png,.pdf" required>
                        <label for="front_id" class="cursor-pointer block">
                            <div class="upload-content">
                                <i class="fas fa-id-card text-4xl text-gray-600 dark:text-gray-400 mb-4"></i>
                                <p class="text-sm text-gray-500">Drop file here or click to upload</p>
                            </div>
                            <div class="preview-container mt-4 hidden">
                                <img src="#" alt="Preview" class="preview-image max-h-32 mx-auto rounded" />
                                <div class="mt-2 text-sm text-gray-500"></div>
                            </div>
                        </label>
                    </div>
                </div>

                <!-- ID Back Section -->
                <div class="space-y-2" id="back-id-section">
                    <h2 class="text-lg font-semibold">ID (back)</h2>
                    <p class="text-sm text-gray-400">This should be a photo of the back of any above ID card you already uploaded.</p>
                    
                    <div class="relative border-2 border-dashed border-gray-700 rounded-lg p-8 text-center cursor-pointer hover:border-gray-600 transition-colors">
                        <input type="file" class="hidden" id="back_id" name="back_id" accept=".jpg,.jpeg,.png,.pdf" required>
                        <label for="back_id" class="cursor-pointer block">
                            <div class="upload-content">
                                <i class="fas fa-id-card text-4xl text-gray-600 dark:text-gray-400 mb-4"></i>
                                <p class="text-sm text-gray-500">Drop file here or click to upload</p>
                            </div>
                            <div class="preview-container mt-4 hidden">
                                <img src="#" alt="Preview" class="preview-image max-h-32 mx-auto rounded" />
                                <div class="mt-2 text-sm text-gray-500"></div>
                            </div>
                        </label>
                    </div>
                </div>

                <!-- Proof of Residence Section -->
                <div class="space-y-2" id="residence-section">
                    <h2 class="text-lg font-semibold">Proof of Residence</h2>
                    <p class="text-sm text-gray-400">This can be your: Water bill, Electricity bill, Telephone bill, Internet bill, Credit card bill or Statement, Bank statement.</p>
                    
                    <div class="relative border-2 border-dashed border-gray-700 rounded-lg p-8 text-center cursor-pointer hover:border-gray-600 transition-colors">
                        <input type="file" class="hidden" id="proof_of_residence" name="proof_of_residence" accept=".jpg,.jpeg,.png,.pdf" required>
                        <label for="proof_of_residence" class="cursor-pointer block">
                            <div class="upload-content">
                                <i class="fas fa-file-alt text-4xl text-gray-600 dark:text-gray-400 mb-4"></i>
                                <p class="text-sm text-gray-500">Drop file here or click to upload</p>
                            </div>
                            <div class="preview-container mt-4 hidden">
                                <img src="#" alt="Preview" class="preview-image max-h-32 mx-auto rounded" />
                                <div class="mt-2 text-sm text-gray-500"></div>
                            </div>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Submit Button -->
            <div class="mt-8">
                <button type="submit" id="submit-btn" class="w-full bg-yellow-500 hover:bg-yellow-600 text-black font-semibold py-3 px-4 rounded-lg transition-colors">
                    Submit for Verification
                </button>
            </div>
        </form>

        <!-- Status Message -->
        <div class="mt-4 text-center text-sm text-gray-400 {{ in_array(auth()->user()->kyc_status, ['pending', 'approved']) ? 'hidden' : '' }}">
            Average verification time: 24-48 hours
        </div>

        <!-- Success/Error Modal -->
        <div id="kyc-modal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center">
            <div class="bg-white dark:bg-gray-800 rounded-lg p-6 max-w-sm w-full mx-4">
                <div id="modal-icon-success" class="hidden">
                    <div class="mx-auto mb-4 text-center">
                        <i class="fas fa-check-circle text-6xl text-green-500"></i>
                    </div>
                    <h2 class="text-xl font-bold text-green-500 text-center mb-4">Submission Successful</h2>
                    <p class="text-gray-600 dark:text-gray-300 text-center mb-4">
                        Your KYC documents have been submitted successfully. 
                        Our team will review your documents shortly.
                    </p>
                </div>
                <div id="modal-icon-error" class="hidden">
                    <div class="mx-auto mb-4 text-center">
                        <i class="fas fa-times-circle text-6xl text-red-500"></i>
                    </div>
                    <h2 class="text-xl font-bold text-red-500 text-center mb-4">Submission Failed</h2>
                    <p id="error-message" class="text-gray-600 dark:text-gray-300 text-center mb-4">
                        There was an error submitting your documents. Please try again.
                    </p>
                </div>
                <button id="modal-close-btn" class="w-full bg-yellow-500 hover:bg-yellow-600 text-black font-semibold py-3 px-4 rounded-lg transition-colors">
                    Close
                </button>
            </div>
        </div>
        
        <!-- KYC Fee Confirmation Modal -->
        <div id="kyc-fee-modal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center">
            <div class="bg-white dark:bg-gray-800 rounded-lg p-6 max-w-sm w-full mx-4">
                <div class="mx-auto mb-4 text-center">
                    <i class="fas fa-coins text-6xl text-yellow-500"></i>
                </div>
                <h2 class="text-xl font-bold text-center mb-4">KYC Verification Fee</h2>
                <p class="text-gray-600 dark:text-gray-300 text-center mb-6">
                    A verification fee of <span class="font-bold text-yellow-500" id="kyc-fee-amount">{{ $kycFeeAmount }}</span> USDT will be charged for processing your KYC application.
                </p>
                <div class="flex flex-col space-y-3">
                    <button id="kyc-fee-proceed-btn" class="w-full bg-yellow-500 hover:bg-yellow-600 text-black font-semibold py-3 px-4 rounded-lg transition-colors">
                        Pay & Proceed
                    </button>
                    <button id="kyc-fee-cancel-btn" class="w-full bg-gray-200 dark:bg-gray-700 hover:bg-gray-300 dark:hover:bg-gray-600 text-gray-800 dark:text-gray-200 font-semibold py-3 px-4 rounded-lg transition-colors">
                        Cancel
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Loading Overlay -->
        <div id="loading-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden items-center justify-center">
            <div class="bg-white dark:bg-gray-800 rounded-lg p-6 max-w-sm w-full mx-4 text-center">
                <div class="animate-spin rounded-full h-16 w-16 border-t-4 border-b-4 border-yellow-500 mx-auto mb-4"></div>
                <h2 class="text-xl font-bold mb-2">Processing Submission</h2>
                <p class="text-gray-600 dark:text-gray-300">Please wait while we process your documents...</p>
            </div>
        </div>
    </main>

    @push('scripts')
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.getElementById('kyc-form');
        const modal = document.getElementById('kyc-modal');
        const modalSuccessIcon = document.getElementById('modal-icon-success');
        const modalErrorIcon = document.getElementById('modal-icon-error');
        const modalCloseBtn = document.getElementById('modal-close-btn');
        const errorMessageEl = document.getElementById('error-message');
        const submitBtn = document.getElementById('submit-btn');
        const loadingOverlay = document.getElementById('loading-overlay');
        
        // KYC Fee related elements
        const kycFeeModal = document.getElementById('kyc-fee-modal');
        const kycFeeProceedBtn = document.getElementById('kyc-fee-proceed-btn');
        const kycFeeCancelBtn = document.getElementById('kyc-fee-cancel-btn');
        
        // Check if KYC fee is enabled
        const kycFeeEnabled = {{ auth()->user()->kyc_fee ? 'true' : 'false' }};
        const kycFeeAmount = {{ auth()->user()->kyc_fee_amount ?? 0 }};
        
        // Update the fee amount in the modal
        document.getElementById('kyc-fee-amount').textContent = kycFeeAmount.toFixed(2);

        // Close modal and reload the page
        modalCloseBtn.addEventListener('click', function() {
            modal.classList.add('hidden');
            modal.classList.remove('flex');
            window.location.reload();
        });

        // Handle form submission with KYC fee check
        form.addEventListener('submit', async function(e) {
            e.preventDefault();
            
            // Disable submit button to prevent double clicks
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Processing...';
            
            if (kycFeeEnabled && kycFeeAmount > 0) {
                // Show KYC fee confirmation modal
                kycFeeModal.classList.remove('hidden');
                kycFeeModal.classList.add('flex');
                
                // Re-enable the button since we're showing the fee modal
                submitBtn.disabled = false;
                submitBtn.innerHTML = 'Submit for Verification';
                return;
            }
            
            // If no fee is required, proceed with form submission directly
            await submitKYCForm();
        });
        
        // Handle proceed button click
        kycFeeProceedBtn.addEventListener('click', async function() {
            // Disable proceed button
            kycFeeProceedBtn.disabled = true;
            kycFeeProceedBtn.innerHTML = '<i class="fas fa-spinner fa-spin mr-2"></i> Processing...';
            
            // Hide the fee modal
            kycFeeModal.classList.add('hidden');
            kycFeeModal.classList.remove('flex');
            
            // Show loading overlay
            loadingOverlay.classList.remove('hidden');
            loadingOverlay.classList.add('flex');
            
            // Proceed with form submission
            await submitKYCForm();
            
            // Re-enable proceed button for future use
            kycFeeProceedBtn.disabled = false;
            kycFeeProceedBtn.innerHTML = 'Pay & Proceed';
        });
        
        // Handle cancel button click
        kycFeeCancelBtn.addEventListener('click', function() {
            // Just hide the modal without submitting
            kycFeeModal.classList.add('hidden');
            kycFeeModal.classList.remove('flex');
            
            // Re-enable the submit button
            submitBtn.disabled = false;
            submitBtn.innerHTML = 'Submit for Verification';
        });
        
        // Function to handle the actual form submission
        async function submitKYCForm() {
            const formData = new FormData(form);
            
            try {
                // Show loading overlay if not already shown
                if (!loadingOverlay.classList.contains('flex')) {
                    loadingOverlay.classList.remove('hidden');
                    loadingOverlay.classList.add('flex');
                }

                const response = await fetch('{{ route("user.kyc.upload") }}', {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    }
                });

                const result = await response.json();

                // Hide loading overlay
                loadingOverlay.classList.add('hidden');
                loadingOverlay.classList.remove('flex');

                // Reset modal states
                modalSuccessIcon.classList.add('hidden');
                modalErrorIcon.classList.add('hidden');

                if (result.status === 'success') {
                    // Show success modal
                    modalSuccessIcon.classList.remove('hidden');
                    modal.classList.remove('hidden');
                    modal.classList.add('flex');

                    // Update page to pending state
                    document.getElementById('kyc-info-banner').classList.add('hidden');
                    document.getElementById('kyc-form').classList.add('hidden');
                    document.getElementById('kyc-pending-banner').classList.remove('hidden');
                } else {
                    // Show error modal
                    errorMessageEl.textContent = result.message || 'There was an error submitting your documents. Please try again.';
                    modalErrorIcon.classList.remove('hidden');
                    modal.classList.remove('hidden');
                    modal.classList.add('flex');
                    
                    // Re-enable the submit button on error
                    submitBtn.disabled = false;
                    submitBtn.innerHTML = 'Submit for Verification';
                }
            } catch (error) {
                console.error('Error:', error);
                
                // Hide loading overlay
                loadingOverlay.classList.add('hidden');
                loadingOverlay.classList.remove('flex');
                
                // Show error modal
                errorMessageEl.textContent = 'An unexpected error occurred. Please try again.';
                modalErrorIcon.classList.remove('hidden');
                modal.classList.remove('hidden');
                modal.classList.add('flex');
                
                // Re-enable the submit button on error
                submitBtn.disabled = false;
                submitBtn.innerHTML = 'Submit for Verification';
            }
        }

        // Fetch initial document status on page load
        async function fetchDocumentStatus() {
            try {
                const response = await fetch('{{ route("user.kyc.status") }}', {
                    headers: {
                        'Accept': 'application/json'
                    }
                });
                const data = await response.json();

                // Hide all banners and form first
                ['kyc-info-banner', 'kyc-reject-banner', 'kyc-pending-banner', 'kyc-approved-banner', 'kyc-form'].forEach(id => {
                    document.getElementById(id).classList.add('hidden');
                });

                // Show appropriate banner based on status
                switch(data.status) {
                    case 'not_submitted':
                        document.getElementById('kyc-info-banner').classList.remove('hidden');
                        document.getElementById('kyc-form').classList.remove('hidden');
                        break;
                    case 'rejected':
                        document.getElementById('kyc-reject-banner').classList.remove('hidden');
                        document.getElementById('kyc-form').classList.remove('hidden');
                        break;   
                    case 'pending':
                        document.getElementById('kyc-pending-banner').classList.remove('hidden');
                        break;
                    case 'approved':
                        document.getElementById('kyc-approved-banner').classList.remove('hidden');
                        break;
                }
            } catch (error) {
                console.error('Error fetching status:', error);
            }
        }

        // Initial status fetch
        fetchDocumentStatus();

        // Function to handle file previews
        function handleFilePreview(inputId) {
            const fileInput = document.getElementById(inputId);
            const uploadBox = fileInput.closest('.relative');
            const previewContainer = uploadBox.querySelector('.preview-container');
            const previewImage = previewContainer.querySelector('.preview-image');
            const previewText = previewContainer.querySelector('.text-sm');

            fileInput.addEventListener('change', function(event) {
                const file = event.target.files[0];

                if (file) {
                    const fileType = file.type;
                    const validImageTypes = ['image/jpeg', 'image/png', 'image/jpg'];

                    if (validImageTypes.includes(fileType)) {
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            previewImage.src = e.target.result;
                            previewImage.alt = file.name;
                            previewContainer.querySelector('.text-sm').textContent = file.name;
                            previewContainer.classList.remove('hidden');
                            uploadBox.querySelector('.upload-content').classList.add('hidden');
                        }
                        reader.readAsDataURL(file);
                    } else if (fileType === 'application/pdf') {
                        previewImage.src = '{{ asset("images/pdf-icon.png") }}'; // Ensure you have a PDF icon in your public/images directory
                        previewImage.alt = 'PDF Icon';
                        previewContainer.querySelector('.text-sm').textContent = file.name;
                        previewContainer.classList.remove('hidden');
                        uploadBox.querySelector('.upload-content').classList.add('hidden');
                    } else {
                        // Unsupported file type
                        alert('Unsupported file type. Please upload an image or PDF.');
                        fileInput.value = ''; // Reset the input
                        previewContainer.classList.add('hidden');
                        uploadBox.querySelector('.upload-content').classList.remove('hidden');
                    }
                } else {
                    // No file selected
                    previewContainer.classList.add('hidden');
                    uploadBox.querySelector('.upload-content').classList.remove('hidden');
                }
            });
        }

        // Initialize file preview handlers for each input
        ['front_id', 'back_id', 'proof_of_residence'].forEach(inputId => {
            handleFilePreview(inputId);
        });
    });
    </script>
    @endpush
</x-user-layout>