    <div class="relative min-h-screen bg-gradient-to-b from-gray-900 via-gray-950 to-black text-white p-5">
        <!-- Header / Search -->
        <div class="flex items-center justify-between mb-6">
            <div class="relative w-full">
                <i class="fas fa-search absolute left-4 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
                <input type="text" 
                       placeholder="Search assets or transactions..." 
                       class="w-full bg-white/10 border border-gray-700 rounded-xl pl-12 pr-4 py-3 text-gray-100 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-yellow-500 transition-all duration-300">
            </div>
        </div>

        <!-- Account ID + Dropdown -->
        <div class="mb-6 flex items-center justify-between">
            <div class="flex items-center space-x-2">
                <button onclick="toggleAccountDropdown()" class="flex items-center space-x-2 hover:text-yellow-400 transition">
                    <span class="text-lg font-semibold tracking-wide" id="accountId">T468032</span>
                    <i class="fas fa-chevron-down text-sm transition-transform duration-200" id="accountDropdownIcon"></i>
                </button>
            </div>

            <div class="relative">
                <button onclick="copyAccountId()" class="text-gray-400 hover:text-yellow-400 transition">
                    <i class="far fa-copy text-xl"></i>
                </button>
                <div id="copyMessage" class="hidden absolute right-0 -top-10 bg-yellow-500 text-black text-xs font-semibold px-2 py-1 rounded shadow-lg">
                    Copied!
                </div>
            </div>

            <!-- Dropdown -->
            <div id="accountDropdown" class="hidden absolute top-full left-0 mt-2 w-48 rounded-xl shadow-lg bg-gray-900 border border-gray-800 ring-1 ring-black/40 z-50">
                <div class="py-1">
                    <form method="POST" action="{{ route('logout') }}" class="w-full">
                        @csrf
                        <button type="submit" class="w-full text-left px-4 py-2 text-sm text-gray-300 hover:bg-gray-800 hover:text-yellow-400 flex items-center transition">
                            <i class="fas fa-sign-out-alt mr-2"></i>
                            Logout
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Balance Section -->
        <div class="bg-white/5 border border-gray-800 rounded-2xl p-6 mb-6 backdrop-blur-xl shadow-inner">
            <div class="flex justify-between items-center">
                <div>
                    <p class="text-gray-400 text-sm uppercase">Total Balance</p>
                    <div class="text-4xl font-bold mt-1">$0.00</div>
                </div>
                <button id="toggleBalance" class="text-gray-400 hover:text-yellow-400 transition">
                    <i id="balanceIcon" class="fas fa-eye-slash text-2xl"></i>
                </button>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="grid grid-cols-4 gap-5 text-center mb-8">
            <div>
                <button class="h-16 w-16 rounded-2xl bg-gradient-to-b from-yellow-500 to-yellow-600 hover:from-yellow-400 hover:to-yellow-500 flex items-center justify-center shadow-lg shadow-yellow-700/30 transition">
                    <i class="fas fa-arrow-up text-2xl text-black"></i>
                </button>
                <span class="block mt-2 text-sm text-gray-300">Send</span>
            </div>
            <div>
                <button class="h-16 w-16 rounded-2xl bg-gradient-to-b from-green-500 to-emerald-600 hover:from-green-400 hover:to-green-500 flex items-center justify-center shadow-lg shadow-green-700/30 transition">
                    <i class="fas fa-arrow-down text-2xl text-black"></i>
                </button>
                <span class="block mt-2 text-sm text-gray-300">Receive</span>
            </div>
            <div>
                <button class="h-16 w-16 rounded-2xl bg-gradient-to-b from-blue-500 to-blue-600 hover:from-blue-400 hover:to-blue-500 flex items-center justify-center shadow-lg shadow-blue-700/30 transition">
                    <i class="fas fa-credit-card text-2xl text-black"></i>
                </button>
                <span class="block mt-2 text-sm text-gray-300">Buy</span>
            </div>
            <div>
                <button class="h-16 w-16 rounded-2xl bg-gradient-to-b from-purple-500 to-indigo-600 hover:from-purple-400 hover:to-indigo-500 flex items-center justify-center shadow-lg shadow-purple-700/30 transition">
                    <i class="fas fa-sync-alt text-2xl text-black"></i>
                </button>
                <span class="block mt-2 text-sm text-gray-300">Swap</span>
            </div>
        </div>

        <!-- Help Text -->
        <p class="text-center text-gray-400 mb-6 text-sm">Access, secure and withdraw your assets safely</p>

        <!-- Connect Wallet Button -->
        <button class="w-full bg-gradient-to-r from-yellow-500 via-amber-400 to-yellow-600 hover:from-yellow-400 hover:to-yellow-500 text-black font-bold py-3 rounded-xl shadow-lg shadow-yellow-700/30 transition-transform transform hover:scale-[1.02]">
            <i class="fas fa-wallet mr-2"></i> Connect Ledger Chain to Trust Wallet
        </button>

        <!-- Crypto Assets List -->
        <div class="mt-10">
            <h2 class="text-lg font-semibold mb-4 tracking-wide">My Crypto Assets</h2>
            <div class="space-y-3">
                <!-- BTC -->
                <div class="flex items-center justify-between bg-white/5 hover:bg-white/10 border border-gray-800 rounded-xl p-4 transition cursor-pointer">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-gradient-to-tr from-orange-500 to-yellow-500 rounded-full flex items-center justify-center shadow-lg">
                            <i class="fab fa-bitcoin text-white text-xl"></i>
                        </div>
                        <div>
                            <div class="flex items-center space-x-2">
                                <span class="font-semibold text-white">BTC</span>
                            </div>
                            <div class="text-sm text-gray-400">
                                $97,107.41 <span class="text-red-500">-2.38%</span>
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="font-semibold">0.0000</div>
                        <div class="text-sm text-gray-400">$0.00</div>
                    </div>
                </div>

                <!-- USDT TRC20 -->
                <div class="flex items-center justify-between bg-white/5 hover:bg-white/10 border border-gray-800 rounded-xl p-4 transition cursor-pointer">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-gradient-to-tr from-green-500 to-emerald-600 rounded-full flex items-center justify-center shadow-lg">
                            <i class="fas fa-dollar-sign text-white text-lg"></i>
                        </div>
                        <div>
                            <div class="flex items-center space-x-2">
                                <span class="font-semibold text-white">USDT</span>
                                <span class="text-xs bg-gray-800 text-gray-300 px-2 py-1 rounded">TRC20</span>
                            </div>
                            <div class="text-sm text-gray-400">
                                $1.00 <span class="text-gray-500">0.00%</span>
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="font-semibold">0.0000</div>
                        <div class="text-sm text-gray-400">$0.00</div>
                    </div>
                </div>

                <!-- USDT ERC20 -->
                <div class="flex items-center justify-between bg-white/5 hover:bg-white/10 border border-gray-800 rounded-xl p-4 transition cursor-pointer">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-gradient-to-tr from-green-500 to-lime-500 rounded-full flex items-center justify-center shadow-lg">
                            <i class="fas fa-link text-white text-lg"></i>
                        </div>
                        <div>
                            <div class="flex items-center space-x-2">
                                <span class="font-semibold text-white">USDT</span>
                                <span class="text-xs bg-gray-800 text-gray-300 px-2 py-1 rounded">ERC20</span>
                            </div>
                            <div class="text-sm text-gray-400">
                                $1.00 <span class="text-gray-500">0.00%</span>
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="font-semibold">0.0000</div>
                        <div class="text-sm text-gray-400">$0.00</div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</x-user-layout>

<script>
    function toggleAccountDropdown() {
        const dropdown = document.getElementById('accountDropdown');
        const icon = document.getElementById('accountDropdownIcon');
        dropdown.classList.toggle('hidden');
        icon.style.transform = dropdown.classList.contains('hidden') ? 'rotate(0deg)' : 'rotate(180deg)';
    }

    async function copyAccountId() {
        const accountId = document.getElementById('accountId').textContent;
        const messageElement = document.getElementById('copyMessage');
        try {
            await navigator.clipboard.writeText(accountId);
            messageElement.classList.remove('hidden');
            setTimeout(() => messageElement.classList.add('hidden'), 2000);
        } catch (err) {
            console.error('Failed to copy: ', err);
        }
    }

    document.addEventListener('click', (event) => {
        const dropdown = document.getElementById('accountDropdown');
        const trigger = event.target.closest('button');
        if (!trigger || !trigger.contains(event.target.closest('.fa-chevron-down'))) {
            dropdown.classList.add('hidden');
            document.getElementById('accountDropdownIcon').style.transform = 'rotate(0deg)';
        }
    });
</script>


