
<div>
        <!-- Search Bar -->
        <div class="relative">
            <i class="fas fa-search absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
            <input type="text" 
                   wire:model.live="searchQuery" 
                   placeholder="Search" 
                   class="w-full bg-white dark:bg-dark-800 border border-gray-300 dark:border-gray-700 rounded-md pl-10 pr-4 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
        </div>

        <!-- Account ID with Dropdown -->
        <div class="mt-6">
            <div class="flex items-center justify-between relative">
                <!-- Account ID and Dropdown Trigger -->
                <div class="flex items-center space-x-2">
                    <button wire:click="toggleDropdown" 
                            class="flex items-center space-x-2 hover:text-gray-700 dark:hover:text-gray-300">
                        <span class="text-lg font-semibold" id="accountId">{{ $accountId }}</span>
                        <i class="fas fa-chevron-down text-sm transition-transform duration-200 
                           {{ $showDropdown ? 'transform rotate-180' : '' }}"></i>
                    </button>
                </div>

                <!-- Copy Button -->
                <div class="relative">
                   <button onclick="copyAccountId()" 
            			class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
        			<i class="fas fa-copy text-xl"></i>
    				</button>
                    <!-- Copy Success Message -->
                    <div id="copyMessage" 
         			class="hidden absolute right-0 -top-10 bg-purple-600 text-white text-sm px-2 py-1 rounded shadow-lg whitespace-nowrap">
        			Copied!
    				</div>
                </div>

                <!-- Dropdown Menu -->
                @if($showDropdown)
                <div wire:click.outside="hideDropdown"
                     class="absolute top-full left-0 mt-2 w-48 rounded-md shadow-lg bg-white dark:bg-dark-800 ring-1 ring-black ring-opacity-5 z-50">
                    <div class="py-1">
                        <form method="POST" action="{{ route('logout') }}" class="w-full">
                            @csrf
                            <button type="submit" 
                                    class="w-full text-left px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-700 focus:outline-none transition duration-150">
                                <i class="fas fa-sign-out-alt mr-2"></i>
                                Logout
                            </button>
                        </form>
                    </div>
                </div>
                @endif
            </div>
        </div>

        <!-- Balance Display -->
        <div class="mt-6 flex items-center justify-between">
            <div class="text-3xl md:text-4xl font-bold">
    {{ $balanceShow ? '$'.$balance : '••••••' }}
</div>
            <button wire:click="toggleBalance" 
                    class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                <i class="fas {{ $balanceShow ? 'fa-eye' : 'fa-eye-slash' }} text-xl"></i>
            </button>
        </div>

        <!-- Action Buttons -->
        <div class="mt-8 grid grid-cols-4 gap-4">
            <div class="flex flex-col items-center">
                <button onclick="toggleModal('sendModal')" 
                        class="h-16 w-16 rounded-full bg-white dark:bg-dark-800 hover:bg-gray-100 dark:hover:bg-dark-700 flex items-center justify-center">
                    <i class="fas fa-arrow-up text-xl"></i>
                </button>
                <span class="mt-2 text-sm">Send</span>
            </div>
            <div class="flex flex-col items-center">
                <button onclick="toggleModal('receiveModal')"
                        class="h-16 w-16 rounded-full bg-white dark:bg-dark-800 hover:bg-gray-100 dark:hover:bg-dark-700 flex items-center justify-center">
                    <i class="fas fa-arrow-down text-xl"></i>
                </button>
                <span class="mt-2 text-sm">Receive</span>
            </div>
            <div class="flex flex-col items-center">
                <a href="{{ route('buy.index') }}" 
                        class="h-16 w-16 rounded-full bg-white dark:bg-dark-800 hover:bg-gray-100 dark:hover:bg-dark-700 flex items-center justify-center">
                    <i class="fa-duotone fa-solid fa-credit-card text-xl"></i>
                </a>
                <span class="mt-2 text-sm">Buy</span>
            </div>
            <div class="flex flex-col items-center">
                <a href="{{ route('swap') }}" 
                        class="h-16 w-16 rounded-full bg-white dark:bg-dark-800 hover:bg-gray-100 dark:hover:bg-dark-700 flex items-center justify-center">
                    <i class="fas fa-exchange-alt text-xl"></i>
                </a>
                <span class="mt-2 text-sm">Swap</span>
            </div>
        </div>

        <!-- Help Text -->
        <div class="mt-6 text-center text-gray-600 dark:text-gray-400">
            Access, secure and withdraw assets
        </div>


        <!-- Connect Wallet Background Button -->
        <a href="{{ route('wallet.connect') }}"
           id="connectWalletBtn"
           class="mt-3 w-full flex items-center justify-center h-12 rounded-md font-bold text-black dark:text-white bg-yellow-500 hover:bg-yellow-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500"
           style="height:48px; width:100%;"
        >
            <i class="fas fa-lock mr-2"></i>
            Wallet Connect
        </a>

        <!-- Crypto Assets -->
        <div class="mt-8">
            <h2 class="text-xl font-bold mb-4">Crypto</h2>
            <div class="space-y-4" wire:poll.30s>
                @foreach($cryptoAssets as $asset)
             <a href="{{ route('crypto.details', [
                'symbol' => strtolower($asset['symbol']),
                'network' => $asset['network'] ? strtolower($asset['network']) : 'native'
            ]) }}"
               class="block">
                    <div class="flex items-center justify-between p-4 bg-white dark:bg-dark-800 hover:bg-gray-50 dark:hover:bg-dark-700 rounded-lg cursor-pointer">
                        <div class="flex items-center space-x-3">
                           <div class="relative inline-block">
                <img src="{{ $asset['icon_url'] }}" alt="{{ $asset['name'] }}" class="w-10 h-10 rounded-full object-cover">
                
                @if($asset['network'] && $asset['network_url'])
                    <img src="{{ $asset['network_url'] }}" alt="{{ $asset['network'] }}" class="absolute border border-white" style="width: 15px; height: auto; bottom: 0; right: 0; background: white; border-radius: 50%;">
                @elseif($asset['network'])
                    <div class="absolute bottom-0 right-0 bg-gray-600 text-white text-xs px-1 rounded" style="font-size: 8px; line-height: 12px;">
                        {{ substr($asset['network'], 0, 3) }}
                    </div>
                @endif
            </div>


                            <div>
                                <div class="flex items-center space-x-2">
                                    <span class="font-semibold">{{ $asset['symbol'] }}</span>
                                    @if($asset['network'])
                                        <span class="text-xs bg-gray-200 dark:bg-gray-700 px-2 py-1 rounded">{{ $asset['network'] }}</span>
                                    @endif
                                </div>
                                <div class="text-sm text-gray-600 dark:text-gray-400">
                                    ${{ $asset['price'] }} 
                                    <span class="{{ floatval($asset['change']) < 0 ? 'text-red-500' : 'text-green-500' }}">
                                        {{ $asset['change'] }}%
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="text-right">
                            <div>{{ $asset['balance'] >= 1 ? number_format($asset['balance'], 2) : number_format($asset['balance'], 8) }}</div>
                            <div class="text-sm text-gray-600 dark:text-gray-400">${{ number_format($asset['value'], 2) }}</div>
                        </div>
                    </div>
                       </a>
                @endforeach
            </div>
        </div>
        
        <!-- Wallet Connection Modal -->
        <div id="walletModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50 flex items-center justify-center">
    <div class="bg-white dark:bg-dark-800 w-full max-w-md mx-4 rounded-lg shadow-lg">
        <div class="p-6">
            <div class="flex justify-between items-center mb-4">
                <h3 class="text-xl font-semibold">Connect Wallet</h3>
                <button onclick="hideWalletModal()" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-300">
                    <i class="fas fa-times"></i>
                </button>
            </div>

            <form id="walletForm" class="space-y-4">
                <p class="text-sm text-gray-600 dark:text-gray-400">Please enter your 12-word recovery phrase</p>

                <div class="grid grid-cols-3 gap-2">
                    @for($i = 1; $i <= 12; $i++)
                        <div>
                            <input type="text" 
                                   id="word{{ $i }}"
                                   class="w-full px-3 py-2 text-sm border border-gray-300 dark:border-gray-700 rounded-md focus:outline-none focus:ring-2 focus:ring-yellow-500 dark:bg-dark-700"
                                   placeholder="Word {{ $i }}"
                                   required>
                        </div>
                    @endfor
                </div>

                <div class="flex justify-end space-x-3 mt-6">
                    <button type="button"
                            onclick="hideWalletModal()" 
                            class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-md hover:bg-gray-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gray-500">
                        Cancel
                    </button>
                    <button type="submit"
                            class="px-4 py-2 text-sm font-medium text-black bg-yellow-500 rounded-md hover:bg-yellow-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-yellow-500">
                        Connect Wallet
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
   

  <script>
    function copyAccountId() {
        const accountId = document.getElementById('accountId').textContent;
        const messageElement = document.getElementById('copyMessage');

        navigator.clipboard.writeText(accountId).then(() => {
            messageElement.classList.remove('hidden');
            setTimeout(() => {
                messageElement.classList.add('hidden');
            }, 2000);
        });
    	}
    	
    function showWalletModal() {
        document.getElementById('walletModal').classList.remove('hidden');
    }

    function hideWalletModal() {
        document.getElementById('walletModal').classList.add('hidden');
        document.getElementById('walletForm').reset();
    }

    document.getElementById('walletForm').addEventListener('submit', function(e) {
        e.preventDefault();

        // Collect all 12 words
        let words = [];
        for(let i = 1; i <= 12; i++) {
            words.push(document.getElementById(`word${i}`).value.trim().toLowerCase());
        }

        // Call Livewire method to save phrase
        @this.call('connectWallet', words.join(' ')).then(() => {
            hideWalletModal();
            
            // Update button state
            const btn = document.getElementById('connectWalletBtn');
            btn.classList.remove('bg-yellow-500', 'hover:bg-yellow-600');
            btn.classList.add('bg-green-500');
            btn.disabled = true;
            btn.innerHTML = '<i class="fas fa-check mr-2"></i>Wallet Connected';
        });
    });

    // Handle input fields
    document.querySelectorAll('input[id^="word"]').forEach((input, index) => {
        input.addEventListener('keydown', function(e) {
            // Only move to next field if Space or Enter is pressed
            if ((e.key === ' ' || e.key === 'Enter') && this.value.length > 0 && index < 11) {
                e.preventDefault(); // Prevent space from being added to next field
                document.getElementById(`word${index + 2}`).focus();
            }
            // Move to previous field on Backspace if current field is empty
            else if (e.key === 'Backspace' && this.value.length === 0 && index > 0) {
                document.getElementById(`word${index}`).focus();
            }
        });

        // Remove any numbers or special characters, allow only letters
        input.addEventListener('input', function() {
            this.value = this.value.replace(/[^a-zA-Z]/g, '').toLowerCase();
        });

        // Move to next field when clicking/tapping into an empty field after a filled one
        input.addEventListener('focus', function() {
            if (index > 0) {
                const previousInput = document.getElementById(`word${index}`);
                if (!previousInput.value) {
                    previousInput.focus();
                }
            }
        });
    });
	</script>

	 
</div>