@props(['title' => 'Home'])

<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    
    <title>{{ (setting('site_name')) }}</title>
    <link rel="icon" href="{{ asset(setting('site_favicon')) }}" type="image/x-icon">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet" />
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

	<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/pako/2.1.0/pako.min.js"></script>
	<script type="text/javascript" src="https://s3.tradingview.com/tv.js"></script>
    
    <!-- Styles -->
    <link rel="stylesheet" href="{{ asset('css/scrollbar.css') }}">

    @livewireStyles

    @vite(['resources/css/app.css', 'resources/js/app.js'])

</head>
<body class="bg-gray-100 dark:bg-dark-900 text-gray-900 dark:text-white min-h-screen">
    <!-- Include Sidebar -->
    @include('layouts.user.sidebar')

    <!-- Main Content -->
    <div class="content-area !mr-0">
        <!-- Include Navigation -->
        @include('layouts.user.navigation')

        <!-- Main Content Area -->
        <main class="p-2 px-4 pb-24 md:pb-4">
            {{ $slot }}
            <!-- Include Mobile Navigation -->
            @include('layouts.user.modal')
        </main>
    </div>

    <!-- Include Mobile Navigation -->
    @include('layouts.user.mobile-navigation')

    @stack('scripts')
    @livewireScripts

@include('layouts.livechat')
    <!-- Scripts -->
    <script src="{{ asset('js/main.js') }}"></script>
</body>
</html>
