@php
    use App\Models\Transaction;
@endphp

@component('mail::message')
@if($type === Transaction::TYPE_SWAP)
{{-- ===================== SWAP TRANSACTION ===================== --}}
# Crypto Swap {{ ucfirst($status) }}

Dear {{ $transaction->user->name }},

Your crypto swap has been **{{ $status }}** successfully.

@component('mail::panel')
### Swap Details
- **From:** {{ number_format($transaction->amount_in ?? 0, 8) }} {{ strtoupper($transaction->fromCoin->display_symbol ?? $crypto) }}
- **To:** {{ number_format($transaction->amount_out ?? 0, 8) }} {{ strtoupper($transaction->toCoin->display_symbol ?? $crypto) }}
- **Rate:** 1 {{ strtoupper($transaction->fromCoin->display_symbol ?? $crypto) }} = {{ number_format($transaction->rate ?? 0, 8) }} {{ strtoupper($transaction->toCoin->display_symbol ?? $crypto) }}
@if(!empty($metadata['usd_value']))
- **USD Value:** ${{ number_format($metadata['usd_value'], 2) }}
@endif
- **Date:** {{ $created_at ? $created_at->format('M d, Y H:i:s') : 'N/A' }}

@if(!empty($metadata['from_price_usd']) && !empty($metadata['to_price_usd']))
**Prices at Time of Swap**
- {{ strtoupper($transaction->fromCoin->display_symbol ?? $crypto) }}: ${{ number_format($metadata['from_price_usd'], 2) }}
- {{ strtoupper($transaction->toCoin->display_symbol ?? $crypto) }}: ${{ number_format($metadata['to_price_usd'], 2) }}
@endif
@endcomponent

@else
{{-- ===================== DEPOSIT / WITHDRAWAL ===================== --}}
# {{ $type === 'deposit' ? 'Crypto Received' : 'Crypto Sent' }} {{ ucfirst($status) }}

Dear {{ $transaction->user->name }},

Your crypto transaction has been **{{ $status }}**.

@component('mail::panel')
### Transaction Details
@if($type === 'withdrawal')
- **Amount Sent:** {{ number_format($transaction->amount_out ?? $amount, 8) }} {{ strtoupper($crypto) }}
@elseif($type === 'deposit')
- **Amount Received:** {{ number_format($transaction->amount_in ?? $amount, 8) }} {{ strtoupper($crypto) }}
@else
- **Amount:** {{ number_format($amount, 8) }} {{ strtoupper($crypto) }}
@endif

- **Status:** {{ ucfirst($status) }}
- **Date:** {{ $created_at ? $created_at->format('M d, Y H:i:s') : 'N/A' }}

@if($network)
- **Network:** {{ strtoupper($network) }}
@endif

@if($type === 'withdrawal' && isset($metadata['network_fee']))
- **Network Fee:** {{ number_format($metadata['network_fee'], 8) }} {{ strtoupper($crypto) }}
@endif

@if(isset($metadata['transaction_hash']))
- **Transaction Hash:**  
  {{ $metadata['transaction_hash'] }}
@endif

@if(isset($metadata['external_address']))
- **Recipient Address:**  
  {{ $metadata['external_address'] }}
@endif

@if($type === 'withdrawal' && isset($metadata['recipient_name']))
- **Sent To:** {{ $metadata['recipient_name'] }}  
  (PayID: {{ $metadata['recipient_payid'] ?? 'N/A' }})
@endif

@if($type === 'deposit' && isset($metadata['sender_name']))
- **Received From:** {{ $metadata['sender_name'] }}  
  (PayID: {{ $metadata['sender_payid'] ?? 'N/A' }})
@endif

@if($status === 'failed' && !empty($reason))
- **Reason for Failure:** {{ $reason }}
@endif
@endcomponent
@endif

@if($status === 'pending')
Your transaction is currently being processed. You’ll receive another notification once it’s completed.
@endif

@if($status === 'failed')
If this transaction failed unexpectedly, please review your details and try again, or contact our support team for assistance.
@endif

If you did **not initiate this transaction** or notice any suspicious activity, please contact our support team immediately at **{{ $supportEmail }}**.

Thanks for choosing **{{ $companyName }}**!  
**{{ $companyName }} Team**
@endcomponent
