@component('mail::message')
# Staking Started

Dear {{ $user->name }},

Your staking has been successfully started. Here are your details:

@component('mail::panel')
**Plan:** {{ $stakingPlan->name }}  
**Amount:** {{ number_format($userStake->amount, 8) }} {{ $stakingPlan->coin->display_symbol }}  
**Lock Duration:** {{ $stakingPlan->lock_duration }} days  
**ROI:** {{ number_format($stakingPlan->return_of_interest, 1) }}% ({{ ucfirst($stakingPlan->interest_type) }})  
**Start:** {{ \Illuminate\Support\Carbon::parse($userStake->start_time)->format('M d, Y H:i') }}  
**End:** {{ \Illuminate\Support\Carbon::parse($userStake->end_time)->format('M d, Y H:i') }}
@endcomponent

You can view your staking status and rewards at any time from your dashboard.

@component('mail::button', ['url' => route('staking')])
View My Stakes
@endcomponent

If you have any questions, please contact our support team.

Best regards,  
{{ config('app.name') }} Team
@endcomponent 