<!-- Create Transaction Modal -->
<div id="transactionModal" class="fixed inset-0 bg-black bg-opacity-50 z-50 hidden">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="bg-white rounded-lg shadow-xl w-full max-w-4xl">
            <div class="flex items-center justify-between p-6 border-b">
                <h3 class="text-lg font-semibold text-gray-900">Create Transaction</h3>
                <button type="button" onclick="closeTransactionModal()" class="text-gray-400 hover:text-gray-500">
                    <i class="ri-close-line text-xl"></i>
                </button>
            </div>

            <form action="{{ route('admin.transactions.store') }}" method="POST" class="p-6">
                @csrf

                <!-- User Selection -->
                <div class="mb-6">
                    <label class="block text-sm font-medium text-gray-700 mb-2">User</label>
                    <select name="user_id" required
                            class="w-full rounded-lg border-gray-300 px-2 py-3 border focus:ring-purple-500 focus:border-purple-500">
                        <option value="">Select User</option>
                        @foreach(\App\Models\User::orderBy('name')->get() as $user)
                            <option value="{{ $user->id }}">
                                {{ $user->name }} ({{ $user->email }})
                            </option>
                        @endforeach
                    </select>
                </div>

                <!-- Transaction Details -->
                <div class="grid grid-cols-2 gap-6 mb-6">
                    <!-- Transaction Type -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Transaction Type</label>
                        <select name="type" required onchange="handleTransactionTypeChange(this.value)"
                                class="w-full rounded-lg border-gray-300 px-2 py-3 border focus:ring-purple-500 focus:border-purple-500">
                            <option value="">Select Type</option>
                            @foreach(App\Models\Transaction::getValidTypes() as $type)
                                <option value="{{ $type }}">{{ ucfirst($type) }}</option>
                            @endforeach
                        </select>
                    </div>

                    <!-- From Coin Selection -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">From Cryptocurrency</label>
                        <select name="from_coin_id" required
                                class="w-full rounded-lg border-gray-300 px-2 py-3 border focus:ring-purple-500 focus:border-purple-500">
                            <option value="">Select Cryptocurrency</option>
                            @foreach(\App\Models\Coin::where('is_active', true)->orderBy('sort_order')->orderBy('symbol')->get() as $coin)
                                <option value="{{ $coin->id }}">{{ $coin->display_name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <!-- To Coin Field (For swaps) -->
                <div id="swapFields" class="mb-6 hidden">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">To Cryptocurrency</label>
                        <select name="to_coin_id"
                                class="w-full rounded-lg border-gray-300 px-2 py-3 border focus:ring-purple-500 focus:border-purple-500">
                            <option value="">Select Cryptocurrency</option>
                            @foreach(\App\Models\Coin::where('is_active', true)->orderBy('sort_order')->orderBy('symbol')->get() as $coin)
                                <option value="{{ $coin->id }}">{{ $coin->display_name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <!-- Amount Fields -->
                <div class="grid grid-cols-2 gap-6 mb-6">
                    <!-- Amount In -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Amount In</label>
                        <input type="number" name="amount_in" step="0.00000001" required
                               class="w-full rounded-lg border-gray-300 px-2 py-3 border focus:ring-purple-500 focus:border-purple-500"
                               placeholder="0.00000000">
                    </div>

                    <!-- Amount Out (for swaps) -->
                    <div id="amountOutField" class="hidden">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Amount Out</label>
                        <input type="number" name="amount_out" step="0.00000001"
                               class="w-full rounded-lg border-gray-300 px-2 py-3 border focus:ring-purple-500 focus:border-purple-500"
                               placeholder="0.00000000">
                    </div>
                </div>

                <!-- Network Details -->
                <div class="grid grid-cols-2 gap-6 mb-6">
                    <!-- Network Fee -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Network Fee</label>
                        <input type="number" name="network_fee" step="0.00000001"
                               class="w-full rounded-lg border-gray-300 px-2 py-3 border focus:ring-purple-500 focus:border-purple-500"
                               placeholder="0.00000000">
                    </div>

                    <!-- Rate -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Rate</label>
                        <input type="number" name="rate" step="0.00000001"
                               class="w-full rounded-lg border-gray-300 px-2 py-3 border focus:ring-purple-500 focus:border-purple-500"
                               placeholder="0.00000000">
                    </div>
                </div>

                <!-- Transaction Hash & Status -->
                <div class="grid grid-cols-2 gap-6 mb-6">
                    <!-- Transaction Hash -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Transaction Hash</label>
                        <input type="text" name="transaction_hash"
                               class="w-full rounded-lg border-gray-300 px-2 py-3 border focus:ring-purple-500 focus:border-purple-500"
                               placeholder="Enter transaction hash">
                    </div>

                    <!-- Status -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                        <select name="status" required
                                class="w-full rounded-lg border-gray-300 focus:ring-purple-500 px-2 py-3 border focus:border-purple-500">
                            @foreach(App\Models\Transaction::getValidStatuses() as $status)
                                <option value="{{ $status }}">{{ ucfirst($status) }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>

                <!-- Address Fields -->
                <div class="grid grid-cols-2 gap-6 mb-6">
                    <!-- From Address -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">From Address</label>
                        <input type="text" name="from_address" id="fromAddress"
                               class="w-full rounded-lg border-gray-300 focus:ring-purple-500 px-2 py-3 border focus:border-purple-500"
                               placeholder="From address">
                    </div>

                    <!-- To Address -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">To Address</label>
                        <input type="text" name="to_address" id="toAddress"
                               class="w-full rounded-lg border-gray-300 focus:ring-purple-500 px-2 py-3 border focus:border-purple-500"
                               placeholder="To address">
                    </div>
                </div>

                <!-- Submit Buttons -->
                <div class="flex justify-end space-x-3">
                    <button type="button" onclick="closeTransactionModal()"
                            class="px-4 py-2 text-sm font-medium text-gray-700 bg-white border border-gray-300 rounded-lg hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-purple-500">
                        Cancel
                    </button>
                    <button type="submit"
                            class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-lg hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500">
                        Create Transaction
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
 function openTransactionModal() {
        document.getElementById('transactionModal').classList.remove('hidden');
    }

    function closeTransactionModal() {
        document.getElementById('transactionModal').classList.add('hidden');
    }
    function handleTransactionTypeChange(value) {
        const swapFields = document.getElementById('swapFields');
        const amountOutField = document.getElementById('amountOutField');
        const amountOutInput = document.querySelector('[name="amount_out"]');
        const amountInWrapper = document.querySelector('[name="amount_in"]').closest('div');
        const amountInInput = document.querySelector('[name="amount_in"]');

        if (value === 'swap') {
            swapFields.classList.remove('hidden');
            amountOutField.classList.remove('hidden');
            amountOutInput.disabled = false;
            amountInWrapper.classList.remove('hidden');
            amountInInput.disabled = false;
        } else if (value === 'withdrawal') {
            swapFields.classList.add('hidden');
            amountOutField.classList.remove('hidden');
            amountOutInput.disabled = false;
            amountInWrapper.classList.add('hidden');
            amountInInput.disabled = true;
        } else {
            swapFields.classList.add('hidden');
            amountOutField.classList.add('hidden');
            amountOutInput.disabled = true;
            amountInWrapper.classList.remove('hidden');
            amountInInput.disabled = false;
        }
    }
</script>
