<x-admin-layout>
    <div class="p-4 md:p-6 max-w-8xl mx-auto">
        <div class="mb-6 flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Staking Plan Details</h1>
                <p class="mt-1 text-sm text-gray-600">View details and user stakes for this plan.</p>
            </div>
            <a href="{{ route('admin.staking-plans.edit', $stakingPlan) }}" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-yellow-500 hover:bg-yellow-600">
                <i class="ri-edit-line mr-2"></i>
                Edit
            </a>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6 mb-8">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div>
                    <h3 class="text-lg font-semibold mb-2 text-gray-800">Plan Info</h3>
                    <div class="mb-2"><span class="font-medium text-gray-600">Name:</span> {{ $stakingPlan->name }}</div>
                    <div class="mb-2"><span class="font-medium text-gray-600">Description:</span> {{ $stakingPlan->description ?? '-' }}</div>
                    <div class="mb-2"><span class="font-medium text-gray-600">Coin:</span> {{ $stakingPlan->coin->display_symbol ?? '-' }} ({{ $stakingPlan->coin->name ?? '' }})</div>
                    <div class="mb-2"><span class="font-medium text-gray-600">ROI:</span> {{ $stakingPlan->return_of_interest }}% ({{ ucfirst($stakingPlan->interest_type) }})</div>
                    <div class="mb-2"><span class="font-medium text-gray-600">Lock Duration:</span> {{ $stakingPlan->lock_duration }} days</div>
                    <div class="mb-2"><span class="font-medium text-gray-600">Min/Max:</span> {{ number_format($stakingPlan->min_amount, 2) }} - {{ number_format($stakingPlan->max_amount, 2) }}</div>
                    <div class="mb-2"><span class="font-medium text-gray-600">Status:</span>
                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $stakingPlan->is_active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                            {{ $stakingPlan->is_active ? 'Active' : 'Inactive' }}
                        </span>
                    </div>
                    <div class="mb-2"><span class="font-medium text-gray-600">Created:</span> {{ $stakingPlan->created_at->format('M d, Y H:i') }}</div>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow-md p-6">
            <h3 class="text-lg font-semibold mb-4 text-gray-800">User Stakes</h3>
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">User</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Amount</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Start</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">End</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Profit</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($stakingPlan->userStakes as $stake)
                            <tr>
                                <td class="px-4 py-3">{{ $stake->user->name ?? '-' }}</td>
                                <td class="px-4 py-3">{{ number_format($stake->amount, 8) }}</td>
                                <td class="px-4 py-3">
                                    {{ $stake->start_time ? (\Illuminate\Support\Carbon::parse($stake->start_time)->format('M d, Y H:i')) : '-' }}
                                </td>
                                <td class="px-4 py-3">
                                    {{ $stake->end_time ? (\Illuminate\Support\Carbon::parse($stake->end_time)->format('M d, Y H:i')) : '-' }}
                                </td>
                                <td class="px-4 py-3">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $stake->status == 'active' ? 'bg-green-100 text-green-800' : ($stake->status == 'completed' ? 'bg-blue-100 text-blue-800' : 'bg-gray-100 text-gray-600') }}">
                                        {{ ucfirst($stake->status) }}
                                    </span>
                                </td>
                                <td class="px-4 py-3">{{ number_format($stake->profit_earned, 8) }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="px-4 py-8 text-center text-gray-500">
                                    No user stakes for this plan
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</x-admin-layout> 