<x-admin-layout>
    <div class="p-4 md:p-6 max-w-8xl mx-auto">
        <div class="mb-6">
            <h1 class="text-2xl font-bold text-gray-900">Add New Staking Plan</h1>
            <p class="mt-1 text-sm text-gray-600">Create a new staking plan for users to invest in.</p>
        </div>
        <x-session-status class="mb-4" :status="session('status')" :errors="$errors" />
        <div class="bg-white rounded-lg shadow-md p-6">
            <form action="{{ route('admin.staking-plans.store') }}" method="POST" class="space-y-4">
                @csrf
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Name</label>
                    <input type="text" name="name" value="{{ old('name') }}" required class="w-full px-3 py-2 border border-gray-300 rounded-md">
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Description</label>
                    <textarea name="description" class="w-full px-3 py-2 border border-gray-300 rounded-md">{{ old('description') }}</textarea>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Min Amount</label>
                        <input type="number" name="min_amount" step="0.00000001" value="{{ old('min_amount') }}" required class="w-full px-3 py-2 border border-gray-300 rounded-md">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Max Amount</label>
                        <input type="number" name="max_amount" step="0.00000001" value="{{ old('max_amount') }}" required class="w-full px-3 py-2 border border-gray-300 rounded-md">
                    </div>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Return of Interest (%)</label>
                        <input type="number" name="return_of_interest" step="0.0001" value="{{ old('return_of_interest') }}" required class="w-full px-3 py-2 border border-gray-300 rounded-md">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Interest Type</label>
                        <select name="interest_type" class="w-full px-3 py-2 border border-gray-300 rounded-md" required>
                            <option value="">Select Type</option>
                            <option value="hourly" @if(old('interest_type')=='hourly') selected @endif>Hourly</option>
                            <option value="daily" @if(old('interest_type')=='daily') selected @endif>Daily</option>
                            <option value="weekly" @if(old('interest_type')=='weekly') selected @endif>Weekly</option>
                        </select>
                    </div>
                </div>
                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Lock Duration (Days)</label>
                        <input type="number" name="lock_duration" min="1" value="{{ old('lock_duration') }}" required class="w-full px-3 py-2 border border-gray-300 rounded-md">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Coin</label>
                        <select name="coin_id" class="w-full px-3 py-2 border border-gray-300 rounded-md" required>
                            <option value="">Select Coin</option>
                            @foreach($coins as $coin)
                                <option value="{{ $coin->id }}" @if(old('coin_id')==$coin->id) selected @endif>
                                    {{ $coin->display_symbol }} ({{ $coin->name }})
                                </option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div>
                    <label class="inline-flex items-center">
                        <input type="checkbox" name="is_active" class="rounded" value="1" @if(old('is_active', true)) checked @endif>
                        <span class="ml-2">Active</span>
                    </label>
                </div>
                <div class="flex justify-end space-x-3 pt-2">
                    <a href="{{ route('admin.staking-plans.index') }}" class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-md hover:bg-gray-200">Cancel</a>
                    <button type="submit" class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-md hover:bg-purple-700">Create Plan</button>
                </div>
            </form>
        </div>
    </div>
</x-admin-layout> 