<x-admin-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">
                {{ __('Wallet Settings') }}
            </h2>
        </div>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 bg-white border-b border-gray-200">
                    
                    <x-session-status class="mb-4" :status="session('status')" :errors="$errors" />

                    <form method="POST" action="{{ route('admin.settings.wallets.update') }}">
                        @csrf
                        @method('PUT')

                        <div class="mb-6">
                            <div class="flex justify-between items-center mb-4">
                                <h3 class="text-lg font-medium">Cryptocurrency Wallet Addresses</h3>
                                <span class="text-sm text-gray-500">Configure wallet addresses for active cryptocurrencies</span>
                            </div>

                            <div class="grid grid-cols-1 gap-6">
                                @php
                                    // Get all active coins from the database
                                    $activeCoins = \App\Models\Coin::where('is_active', true)
                                        ->orderBy('sort_order')
                                        ->orderBy('symbol')
                                        ->get();
                                @endphp

                                @foreach($activeCoins as $coin)
                                    @php
                                        // Generate field name based on coin symbol and network
                                        $fieldName = strtolower($coin->symbol);
                                        if ($coin->network) {
                                            $fieldName .= '_' . strtolower($coin->network);
                                        }
                                        $fieldName .= '_address';
                                        
                                        // Create display name
                                        $displayName = $coin->name;
                                        if ($coin->network) {
                                            $displayName .= " ({$coin->network})";
                                        }
                                        $displayName .= " ({$coin->symbol})";
                                    @endphp
                                    
                                    <div>
                                        <label for="{{ $fieldName }}" class="block text-sm font-medium text-gray-700">
                                            {{ $displayName }} Address
                                        </label>
                                        <div class="mt-1 relative">
                                            <input type="text" 
                                                   name="{{ $fieldName }}" 
                                                   id="{{ $fieldName }}"
                                                   value="{{ old($fieldName, $settings[$fieldName] ?? '') }}"
                                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 focus:border-transparent bg-white text-gray-700"
                                                   placeholder="Enter {{ $coin->symbol }} {{ $coin->network ? '(' . $coin->network . ')' : '' }} wallet address">
                                            @if($coin->image_url)
                                                <div class="absolute inset-y-0 right-0 pr-3 flex items-center">
                                                    <img src="{{ $coin->image_url }}" 
                                                         alt="{{ $coin->symbol }}" 
                                                         class="h-5 w-5">
                                                </div>
                                            @endif
                                        </div>
                                        @if($coin->address_validation_regex)
                                            <p class="mt-1 text-xs text-gray-500">
                                                Address format validation is enabled for this cryptocurrency
                                            </p>
                                        @endif
                                    </div>
                                @endforeach

                                @if($activeCoins->isEmpty())
                                    <div class="text-center py-8">
                                        <p class="text-gray-500">No active cryptocurrencies found.</p>
                                        <a href="{{ route('admin.coins.index') }}" 
                                           class="text-purple-600 hover:text-purple-700 text-sm">
                                            Manage Cryptocurrencies →
                                        </a>
                                    </div>
                                @endif
                            </div>
                        </div>

                        @if($activeCoins->isNotEmpty())
                            <div class="flex justify-end">
                                <button type="submit" 
                                        class="px-4 py-2 bg-purple-600 text-white rounded hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-offset-2">
                                    Save Wallet Settings
                                </button>
                            </div>
                        @endif
                    </form>
                </div>
            </div>
        </div>
    </div>
</x-admin-layout>