<x-admin-layout>
    <div class="p-4 md:p-6">
        <div class="mb-6">
            <div class="flex items-center justify-between mb-4">
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.coins.index') }}" class="text-purple-600 hover:text-purple-800">
                        <i class="ri-arrow-left-line text-xl"></i>
                    </a>
                    <div class="flex items-center space-x-4">
                        @if($coin->image)
                            <img src="{{ $coin->image_url }}" alt="{{ $coin->name }}" class="h-12 w-12 rounded-full object-cover border">
                        @else
                            <div class="h-12 w-12 rounded-full bg-gray-300 flex items-center justify-center">
                                <i class="ri-coin-line text-gray-500 text-xl"></i>
                            </div>
                        @endif
                        <div>
                            <h1 class="text-2xl font-bold text-gray-900">{{ $coin->name }}</h1>
                            <p class="text-sm text-gray-600">{{ $coin->display_name }}</p>
                        </div>
                    </div>
                </div>
                <div class="flex space-x-3">
                    <a href="{{ route('admin.coins.edit', $coin) }}" class="inline-flex items-center px-3 py-2 border border-gray-300 shadow-sm text-sm leading-4 font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        <i class="ri-edit-line mr-2"></i>
                        Edit
                    </a>
                    <button type="button" onclick="checkSupport()" class="inline-flex items-center px-3 py-2 border border-gray-300 shadow-sm text-sm leading-4 font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                        <i class="ri-shield-check-line mr-2"></i>
                        Check Support
                    </button>
                </div>
            </div>

            <x-session-status class="mb-4" :status="session('status')" />
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
            <!-- Main Information -->
            <div class="lg:col-span-2 space-y-6">
                <!-- Basic Details -->
                <div class="bg-white rounded-lg shadow-md p-6">
                    <h2 class="text-lg font-medium text-gray-900 mb-4">Basic Information</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Coin Name</label>
                            <p class="text-sm text-gray-900">{{ $coin->name }}</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Symbol</label>
                            <p class="text-sm font-mono font-medium text-gray-900">{{ $coin->symbol }}</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Display Symbol</label>
                            <p class="text-sm text-gray-900">{{ $coin->display_symbol }}</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Network</label>
                            @if($coin->network)
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                    {{ $coin->network }}
                                </span>
                            @else
                                <span class="text-sm text-gray-500">Native blockchain</span>
                            @endif
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Price Symbol</label>
                            <p class="text-sm font-mono text-gray-900">{{ $coin->price_symbol }}</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Decimals</label>
                            <p class="text-sm text-gray-900">{{ $coin->decimals }}</p>
                        </div>
                    </div>
                </div>

                <!-- Fees Configuration -->
                <div class="bg-white rounded-lg shadow-md p-6">
                    <h2 class="text-lg font-medium text-gray-900 mb-4">Fees Configuration</h2>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Default Send Fee</label>
                            <p class="text-sm text-gray-900">{{ $coin->default_fee }} {{ $coin->symbol }}</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Default Swap Fee</label>
                            <p class="text-sm text-gray-900">{{ $coin->default_swap_fee }} {{ $coin->symbol }}</p>
                        </div>
                    </div>
                </div>

                <!-- Address Validation -->
                <div class="bg-white rounded-lg shadow-md p-6">
                    <h2 class="text-lg font-medium text-gray-900 mb-4">Address Validation</h2>
                    <div>
                        <label class="block text-sm font-medium text-gray-500 mb-1">Validation Regex</label>
                        <p class="text-sm font-mono text-gray-900 bg-gray-50 p-3 rounded border break-all">{{ $coin->address_validation_regex }}</p>
                    </div>
                </div>

                <!-- Exchange Support Status -->
                @if($supportStatus)
                    <div class="bg-white rounded-lg shadow-md p-6">
                        <div class="flex items-center justify-between mb-4">
                            <h2 class="text-lg font-medium text-gray-900">Exchange Support</h2>
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium
                                @if($supportStatus['status'] === 'excellent') bg-green-100 text-green-800
                                @elseif($supportStatus['status'] === 'good') bg-blue-100 text-blue-800
                                @elseif($supportStatus['status'] === 'limited') bg-yellow-100 text-yellow-800
                                @else bg-red-100 text-red-800 @endif">
                                {{ ucfirst($supportStatus['status']) }} 
                                ({{ $supportStatus['supported_count'] }}/{{ $supportStatus['total_count'] }})
                            </span>
                        </div>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                            @foreach($supportStatus['results'] as $exchange => $status)
                                <div class="border rounded-lg p-4">
                                    <div class="flex items-center justify-between mb-2">
                                        <h3 class="text-sm font-medium capitalize">{{ $exchange }}</h3>
                                        @if($status['supported'])
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                                <i class="ri-check-line mr-1"></i>
                                                Supported
                                            </span>
                                        @else
                                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                                <i class="ri-close-line mr-1"></i>
                                                Not Supported
                                            </span>
                                        @endif
                                    </div>
                                    @if(isset($status['last_checked']))
                                        <p class="text-xs text-gray-500">
                                            Last checked: {{ \Carbon\Carbon::parse($status['last_checked'])->diffForHumans() }}
                                        </p>
                                    @endif
                                    @if(isset($status['error']))
                                        <p class="text-xs text-red-500 mt-1">{{ $status['error'] }}</p>
                                    @endif
                                </div>
                            @endforeach
                        </div>
                    </div>
                @else
                    <div class="bg-white rounded-lg shadow-md p-6">
                        <h2 class="text-lg font-medium text-gray-900 mb-4">Exchange Support</h2>
                        <div class="text-center py-8">
                            <i class="ri-shield-line text-gray-400 text-4xl mb-4"></i>
                            <p class="text-gray-500 mb-4">Exchange support hasn't been checked yet</p>
                            <button type="button" onclick="checkSupport()" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-purple-600 hover:bg-purple-700">
                                <i class="ri-shield-check-line mr-2"></i>
                                Check Support Now
                            </button>
                        </div>
                    </div>
                @endif
            </div>

            <!-- Sidebar -->
            <div class="space-y-6">
                <!-- Status Card -->
                <div class="bg-white rounded-lg shadow-md p-6">
                    <h2 class="text-lg font-medium text-gray-900 mb-4">Status</h2>
                    <div class="space-y-4">
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Active Status</span>
                            <button type="button" onclick="toggleStatus()" class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $coin->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                <i class="ri-{{ $coin->is_active ? 'check' : 'close' }}-line mr-1"></i>
                                {{ $coin->is_active ? 'Active' : 'Inactive' }}
                            </button>
                        </div>
                        
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Sort Order</span>
                            <span class="text-sm font-medium text-gray-900">{{ $coin->sort_order }}</span>
                        </div>

                        @if($coin->use_manual_price)
                            <div class="flex items-center justify-between">
                                <span class="text-sm text-gray-600">Manual Price</span>
                                <span class="text-sm font-medium text-gray-900">${{ number_format($coin->manual_price_usd, 8) }}</span>
                            </div>
                        @endif

                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600">Price Check Status</span>
                            @if($coin->price_check_status === 'supported')
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                    <i class="ri-check-line mr-1"></i>
                                    Supported
                                </span>
                            @elseif($coin->price_check_status === 'unsupported')
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                    <i class="ri-close-line mr-1"></i>
                                    Unsupported
                                </span>
                            @else
                                <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                    <i class="ri-question-line mr-1"></i>
                                    Unknown
                                </span>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Timestamps -->
                <div class="bg-white rounded-lg shadow-md p-6">
                    <h2 class="text-lg font-medium text-gray-900 mb-4">Timeline</h2>
                    <div class="space-y-3">
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Created</label>
                            <p class="text-sm text-gray-900">{{ $coin->created_at->format('M j, Y \a\t g:i A') }}</p>
                            <p class="text-xs text-gray-500">{{ $coin->created_at->diffForHumans() }}</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-500 mb-1">Last Updated</label>
                            <p class="text-sm text-gray-900">{{ $coin->updated_at->format('M j, Y \a\t g:i A') }}</p>
                            <p class="text-xs text-gray-500">{{ $coin->updated_at->diffForHumans() }}</p>
                        </div>
                        @if($coin->last_price_check)
                            <div>
                                <label class="block text-sm font-medium text-gray-500 mb-1">Last Price Check</label>
                                <p class="text-sm text-gray-900">{{ $coin->last_price_check->format('M j, Y \a\t g:i A') }}</p>
                                <p class="text-xs text-gray-500">{{ $coin->last_price_check->diffForHumans() }}</p>
                            </div>
                        @endif
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="bg-white rounded-lg shadow-md p-6">
                    <h2 class="text-lg font-medium text-gray-900 mb-4">Quick Actions</h2>
                    <div class="space-y-3">
                        <button type="button" onclick="checkSupport()" class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                            <i class="ri-shield-check-line mr-2"></i>
                            Check Exchange Support
                        </button>
                        <button type="button" onclick="toggleStatus()" class="w-full inline-flex items-center justify-center px-4 py-2 border border-gray-300 shadow-sm text-sm font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                            <i class="ri-toggle-line mr-2"></i>
                            {{ $coin->is_active ? 'Deactivate' : 'Activate' }} Coin
                        </button>
                        <a href="{{ route('admin.coins.edit', $coin) }}" class="w-full inline-flex items-center justify-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-purple-600 hover:bg-purple-700">
                            <i class="ri-edit-line mr-2"></i>
                            Edit Configuration
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Loading Modal -->
    <div id="loading-modal" class="fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full hidden z-50">
        <div class="relative top-20 mx-auto p-5 border w-96 shadow-lg rounded-md bg-white">
            <div class="mt-3 text-center">
                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-purple-100">
                    <i class="ri-loader-4-line text-purple-600 text-2xl animate-spin"></i>
                </div>
                <h3 class="text-lg leading-6 font-medium text-gray-900 mt-4">Checking Support</h3>
                <div class="mt-2 px-7 py-3">
                    <p class="text-sm text-gray-500">Please wait while we check exchange support for {{ $coin->name }}...</p>
                </div>
            </div>
        </div>
    </div>

    <script>
        function showLoading() {
            document.getElementById('loading-modal').classList.remove('hidden');
        }

        function hideLoading() {
            document.getElementById('loading-modal').classList.add('hidden');
        }

        function checkSupport() {
            showLoading();
            
            fetch(`{{ route('admin.coins.check-support', $coin) }}`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                hideLoading();
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                hideLoading();
                console.error('Error:', error);
                alert('An error occurred while checking support.');
            });
        }

        function toggleStatus() {
            fetch(`{{ route('admin.coins.toggle-status', $coin) }}`, {
                method: 'PATCH',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while updating the status.');
            });
        }
    </script>
</x-admin-layout> 