<x-admin-layout>
    <div class="p-4 md:p-6">
        <div class="mb-6">
            <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-4">
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">Cryptocurrency Management</h1>
                    <p class="mt-1 text-sm text-gray-600">Manage cryptocurrencies, check exchange support, and configure settings</p>
                </div>
                <div class="mt-4 md:mt-0 flex space-x-3">
                    <form method="POST" action="{{ route('admin.coins.clear-cache') }}" class="inline">
                        @csrf
                        <button type="submit" class="inline-flex items-center px-3 py-2 border border-gray-300 shadow-sm text-sm leading-4 font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500">
                            <i class="ri-refresh-line mr-2"></i>
                            Clear Cache
                        </button>
                    </form>
                    <a href="{{ route('admin.coins.create') }}" class="inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md shadow-sm text-white bg-purple-600 hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500">
                        <i class="ri-add-line mr-2"></i>
                        Add New Coin
                    </a>
                </div>
            </div>

            <x-session-status class="mb-4" :status="session('status')" />
            @if (session('success'))
                <div class="mb-4 p-4 bg-green-100 border border-green-400 text-green-700 rounded-md">
                    {{ session('success') }}
                </div>
            @endif
            @if (session('error'))
                <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded-md">
                    {{ session('error') }}
                </div>
            @endif
        </div>

        <!-- Filters -->
        <div class="bg-white rounded-lg shadow-md p-4 mb-6">
            <form method="GET" action="{{ route('admin.coins.index') }}" class="grid grid-cols-1 md:grid-cols-4 gap-4">
                <div>
                    <label for="search" class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                    <input type="text" name="search" id="search" value="{{ request('search') }}" 
                           placeholder="Name, symbol, or display symbol..." 
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500">
                </div>
                <div>
                    <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                    <select name="status" id="status" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500">
                        <option value="">All Status</option>
                        <option value="active" {{ request('status') === 'active' ? 'selected' : '' }}>Active</option>
                        <option value="inactive" {{ request('status') === 'inactive' ? 'selected' : '' }}>Inactive</option>
                    </select>
                </div>
                <div>
                    <label for="support_status" class="block text-sm font-medium text-gray-700 mb-1">Exchange Support</label>
                    <select name="support_status" id="support_status" class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500">
                        <option value="">All Support Status</option>
                        <option value="supported" {{ request('support_status') === 'supported' ? 'selected' : '' }}>Supported</option>
                        <option value="unsupported" {{ request('support_status') === 'unsupported' ? 'selected' : '' }}>Unsupported</option>
                    </select>
                </div>
                <div class="flex items-end space-x-2">
                    <button type="submit" class="flex-1 bg-purple-600 text-white px-4 py-2 rounded-md hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500">
                        <i class="ri-search-line mr-2"></i>Filter
                    </button>
                    <a href="{{ route('admin.coins.index') }}" class="px-3 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50">
                        <i class="ri-close-line"></i>
                    </a>
                </div>
            </form>
        </div>

        <!-- Bulk Actions -->
        <div class="bg-white rounded-lg shadow-md mb-6">
            <div class="p-4 border-b">
                <div class="flex items-center justify-between">
                    <div class="flex items-center">
                        <input type="checkbox" id="select-all" class="h-4 w-4 text-purple-600 focus:ring-purple-500 border-gray-300 rounded">
                        <label for="select-all" class="ml-2 text-sm text-gray-700">Select All</label>
                        <span id="selected-count" class="ml-4 text-sm text-gray-500">0 selected</span>
                    </div>
                    <div id="bulk-actions" class="hidden flex space-x-2">
                        <button type="button" id="bulk-check-support" class="inline-flex items-center px-3 py-2 border border-gray-300 shadow-sm text-sm leading-4 font-medium rounded-md text-gray-700 bg-white hover:bg-gray-50">
                            <i class="ri-shield-check-line mr-2"></i>
                            Check Support
                        </button>
                    </div>
                </div>
            </div>

            <!-- Coins Table -->
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left">
                                <input type="checkbox" class="h-4 w-4 text-purple-600 focus:ring-purple-500 border-gray-300 rounded">
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Coin</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Symbol</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Network</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Fees</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Exchange Support</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse($coins as $coin)
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <input type="checkbox" class="coin-checkbox h-4 w-4 text-purple-600 focus:ring-purple-500 border-gray-300 rounded" value="{{ $coin->id }}">
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="h-10 w-10 flex-shrink-0">
                                            @if($coin->image)
                                                <img class="h-10 w-10 rounded-full object-cover" src="{{ $coin->image_url }}" alt="{{ $coin->name }}">
                                            @else
                                                <div class="h-10 w-10 rounded-full bg-gray-300 flex items-center justify-center">
                                                    <i class="ri-coin-line text-gray-500 text-xl"></i>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="ml-4">
                                            <div class="text-sm font-medium text-gray-900">{{ $coin->name }}</div>
                                            <div class="text-sm text-gray-500">{{ $coin->display_name }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-mono font-medium text-gray-900">{{ $coin->symbol }}</div>
                                    <div class="text-sm text-gray-500">{{ $coin->display_symbol }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($coin->network)
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-blue-100 text-blue-800">
                                            {{ $coin->network }}
                                        </span>
                                    @else
                                        <span class="text-sm text-gray-500">Native</span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <div>Send: {{ $coin->default_fee }}</div>
                                    <div class="text-gray-500">Swap: {{ $coin->default_swap_fee }}</div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($coin->price_check_status === 'supported')
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800">
                                            <i class="ri-check-line mr-1"></i>
                                            Supported
                                        </span>
                                    @elseif($coin->price_check_status === 'unsupported')
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-red-100 text-red-800">
                                            <i class="ri-close-line mr-1"></i>
                                            Unsupported
                                        </span>
                                    @else
                                        <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-800">
                                            <i class="ri-question-line mr-1"></i>
                                            Unknown
                                        </span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <button type="button" 
                                            onclick="toggleCoinStatus({{ $coin->id }}, {{ $coin->is_active ? 'false' : 'true' }})"
                                            class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $coin->is_active ? 'bg-green-100 text-green-800' : 'bg-gray-100 text-gray-800' }}">
                                        <i class="ri-{{ $coin->is_active ? 'check' : 'close' }}-line mr-1"></i>
                                        {{ $coin->is_active ? 'Active' : 'Inactive' }}
                                    </button>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <div class="flex space-x-2">
                                        <a href="{{ route('admin.coins.show', $coin) }}" class="text-purple-600 hover:text-purple-900">
                                            <i class="ri-eye-line"></i>
                                        </a>
                                        <a href="{{ route('admin.coins.edit', $coin) }}" class="text-blue-600 hover:text-blue-900">
                                            <i class="ri-edit-line"></i>
                                        </a>
                                        <button type="button" onclick="checkCoinSupport({{ $coin->id }})" class="text-green-600 hover:text-green-900">
                                            <i class="ri-shield-check-line"></i>
                                        </button>
                                        <button type="button" onclick="deleteCoin({{ $coin->id }}, '{{ $coin->name }}')" class="text-red-600 hover:text-red-900">
                                            <i class="ri-delete-bin-line"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="8" class="px-6 py-12 text-center">
                                    <div class="text-gray-500">
                                        <i class="ri-coin-line text-4xl mb-4"></i>
                                        <p class="text-lg font-medium">No coins found</p>
                                        <p class="mt-2">Get started by adding your first cryptocurrency.</p>
                                        <a href="{{ route('admin.coins.create') }}" class="mt-4 inline-flex items-center px-4 py-2 border border-transparent text-sm font-medium rounded-md text-white bg-purple-600 hover:bg-purple-700">
                                            <i class="ri-add-line mr-2"></i>
                                            Add New Coin
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            @if($coins->hasPages())
                <div class="px-6 py-4 border-t">
                    {{ $coins->appends(request()->query())->links() }}
                </div>
            @endif
        </div>
    </div>

    <!-- Hidden forms for actions -->
    <form id="delete-form" method="POST" style="display: none;">
        @csrf
        @method('DELETE')
    </form>

    <script>
        // Select all functionality
        document.getElementById('select-all').addEventListener('change', function() {
            const checkboxes = document.querySelectorAll('.coin-checkbox');
            checkboxes.forEach(checkbox => {
                checkbox.checked = this.checked;
            });
            updateBulkActions();
        });

        // Individual checkbox functionality
        document.querySelectorAll('.coin-checkbox').forEach(checkbox => {
            checkbox.addEventListener('change', updateBulkActions);
        });

        function updateBulkActions() {
            const checkboxes = document.querySelectorAll('.coin-checkbox:checked');
            const count = checkboxes.length;
            const bulkActions = document.getElementById('bulk-actions');
            const selectedCount = document.getElementById('selected-count');
            
            selectedCount.textContent = count + ' selected';
            
            if (count > 0) {
                bulkActions.classList.remove('hidden');
            } else {
                bulkActions.classList.add('hidden');
            }
        }

        // Bulk check support
        document.getElementById('bulk-check-support').addEventListener('click', function() {
            const checkboxes = document.querySelectorAll('.coin-checkbox:checked');
            const coinIds = Array.from(checkboxes).map(cb => cb.value);
            
            if (coinIds.length === 0) {
                alert('Please select at least one coin.');
                return;
            }

            fetch('{{ route('admin.coins.bulk-check-support') }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                },
                body: JSON.stringify({ coin_ids: coinIds })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while checking support.');
            });
        });

        // Toggle coin status
        function toggleCoinStatus(coinId, newStatus) {
            fetch(`/admin/coins/${coinId}/toggle-status`, {
                method: 'PATCH',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while updating the status.');
            });
        }

        // Check coin support
        function checkCoinSupport(coinId) {
            fetch(`/admin/coins/${coinId}/check-support`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    location.reload();
                } else {
                    alert('Error: ' + data.message);
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('An error occurred while checking support.');
            });
        }

        // Delete coin
        function deleteCoin(coinId, coinName) {
            if (confirm(`Are you sure you want to delete ${coinName}? This action cannot be undone.`)) {
                const form = document.getElementById('delete-form');
                form.action = `/admin/coins/${coinId}`;
                form.submit();
            }
        }
    </script>
</x-admin-layout> 