<x-admin-layout>
    <div class="p-4 md:p-6">
        <div class="mb-6">
            <div class="flex items-center space-x-4 mb-4">
                <a href="{{ route('admin.coins.index') }}" class="text-purple-600 hover:text-purple-800">
                    <i class="ri-arrow-left-line text-xl"></i>
                </a>
                <div>
                    <h1 class="text-2xl font-bold text-gray-900">Add New Cryptocurrency</h1>
                    <p class="mt-1 text-sm text-gray-600">Configure a new cryptocurrency for your platform</p>
                </div>
            </div>

            @if ($errors->any())
                <div class="mb-4 p-4 bg-red-100 border border-red-400 text-red-700 rounded-md">
                    <h4 class="font-medium mb-2">Please correct the following errors:</h4>
                    <ul class="list-disc list-inside space-y-1">
                        @foreach ($errors->all() as $error)
                            <li class="text-sm">{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
        </div>

        <form method="POST" action="{{ route('admin.coins.store') }}" enctype="multipart/form-data" class="space-y-6">
            @csrf

            <!-- Basic Information -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="text-lg font-medium text-gray-900 mb-4">Basic Information</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="name" class="block text-sm font-medium text-gray-700 mb-1">Coin Name *</label>
                        <input type="text" name="name" id="name" value="{{ old('name') }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500"
                               placeholder="e.g., Bitcoin">
                        @error('name')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="symbol" class="block text-sm font-medium text-gray-700 mb-1">Symbol *</label>
                        <input type="text" name="symbol" id="symbol" value="{{ old('symbol') }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500"
                               placeholder="e.g., BTC" maxlength="10">
                        @error('symbol')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="display_symbol" class="block text-sm font-medium text-gray-700 mb-1">Display Symbol *</label>
                        <input type="text" name="display_symbol" id="display_symbol" value="{{ old('display_symbol') }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500"
                               placeholder="e.g., BTC">
                        @error('display_symbol')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="network" class="block text-sm font-medium text-gray-700 mb-1">Network (Optional)</label>
                        <input type="text" name="network" id="network" value="{{ old('network') }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500"
                               placeholder="e.g., TRC20, ERC20, BEP20">
                        @error('network')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="price_symbol" class="block text-sm font-medium text-gray-700 mb-1">Price Symbol *</label>
                        <input type="text" name="price_symbol" id="price_symbol" value="{{ old('price_symbol') }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500"
                               placeholder="e.g., bitcoin (for CoinGecko)">
                        <p class="text-xs text-gray-500 mt-1">Used for price fetching from exchanges</p>
                        @error('price_symbol')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="decimals" class="block text-sm font-medium text-gray-700 mb-1">Decimals *</label>
                        <input type="number" name="decimals" id="decimals" value="{{ old('decimals', 8) }}" required min="0" max="18"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500">
                        @error('decimals')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Image Configuration -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="text-lg font-medium text-gray-900 mb-4">Image Configuration</h2>
                <div class="space-y-4">
                    <div class="flex items-center space-x-4">
                        <input type="radio" id="image-url" name="image_type" value="url" checked class="h-4 w-4 text-purple-600 focus:ring-purple-500 border-gray-300">
                        <label for="image-url" class="text-sm font-medium text-gray-700">Use Image URL</label>
                        
                        <input type="radio" id="image-file" name="image_type" value="file" class="h-4 w-4 text-purple-600 focus:ring-purple-500 border-gray-300">
                        <label for="image-file" class="text-sm font-medium text-gray-700">Upload Image File</label>
                    </div>

                    <div id="url-input" class="space-y-2">
                        <label for="image_url" class="block text-sm font-medium text-gray-700">Image URL</label>
                        <input type="url" name="image_url" id="image_url" value="{{ old('image_url') }}"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500"
                               placeholder="https://example.com/coin-image.png">
                        @error('image_url')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div id="file-input" class="space-y-2 hidden">
                        <label for="image_file" class="block text-sm font-medium text-gray-700">Upload Image</label>
                        <input type="file" name="image_file" id="image_file" accept="image/*"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500">
                        <p class="text-xs text-gray-500">PNG, JPG, JPEG, SVG up to 2MB</p>
                        @error('image_file')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div id="image-preview" class="hidden">
                        <label class="block text-sm font-medium text-gray-700 mb-2">Preview</label>
                        <img id="preview-img" class="h-16 w-16 rounded-full object-cover border">
                    </div>
                </div>
            </div>

            <!-- Fees Configuration -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="text-lg font-medium text-gray-900 mb-4">Fees Configuration</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="default_fee" class="block text-sm font-medium text-gray-700 mb-1">Default Send Fee *</label>
                        <input type="number" name="default_fee" id="default_fee" value="{{ old('default_fee', '0.001') }}" required min="0" step="0.000001"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500">
                        @error('default_fee')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="default_swap_fee" class="block text-sm font-medium text-gray-700 mb-1">Default Swap Fee *</label>
                        <input type="number" name="default_swap_fee" id="default_swap_fee" value="{{ old('default_swap_fee', '0.0001') }}" required min="0" step="0.000001"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500">
                        @error('default_swap_fee')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>
                </div>
            </div>

            <!-- Address Validation -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="text-lg font-medium text-gray-900 mb-4">Address Validation</h2>
                <div>
                    <label for="address_validation_regex" class="block text-sm font-medium text-gray-700 mb-1">Validation Regex Pattern *</label>
                    <input type="text" name="address_validation_regex" id="address_validation_regex" value="{{ old('address_validation_regex') }}" required
                           class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500 font-mono text-sm"
                           placeholder="^[13][a-km-zA-HJ-NP-Z1-9]{25,34}$">
                    <p class="text-xs text-gray-500 mt-1">Regular expression to validate wallet addresses for this coin</p>
                    @error('address_validation_regex')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>

            <!-- Advanced Settings -->
            <div class="bg-white rounded-lg shadow-md p-6">
                <h2 class="text-lg font-medium text-gray-900 mb-4">Advanced Settings</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="sort_order" class="block text-sm font-medium text-gray-700 mb-1">Sort Order *</label>
                        <input type="number" name="sort_order" id="sort_order" value="{{ old('sort_order', 100) }}" required min="1"
                               class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500">
                        <p class="text-xs text-gray-500 mt-1">Lower numbers appear first</p>
                        @error('sort_order')
                            <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="space-y-3">
                        <div class="flex items-center">
                            <input type="checkbox" name="is_active" id="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}
                                   class="h-4 w-4 text-purple-600 focus:ring-purple-500 border-gray-300 rounded">
                            <label for="is_active" class="ml-2 text-sm text-gray-700">Active</label>
                        </div>

                        <div class="flex items-center">
                            <input type="checkbox" name="use_manual_price" id="use_manual_price" value="1" {{ old('use_manual_price') ? 'checked' : '' }}
                                   class="h-4 w-4 text-purple-600 focus:ring-purple-500 border-gray-300 rounded">
                            <label for="use_manual_price" class="ml-2 text-sm text-gray-700">Use Manual Price</label>
                        </div>

                        <div id="manual-price-input" class="hidden">
                            <label for="manual_price_usd" class="block text-sm font-medium text-gray-700 mb-1">Manual Price (USD)</label>
                            <input type="number" name="manual_price_usd" id="manual_price_usd" value="{{ old('manual_price_usd') }}" min="0" step="0.00000001"
                                   class="w-full px-3 py-2 border border-gray-300 rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500">
                            @error('manual_price_usd')
                                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>

                        <div class="flex items-center">
                            <input type="checkbox" name="check_support" id="check_support" value="1" {{ old('check_support', true) ? 'checked' : '' }}
                                   class="h-4 w-4 text-purple-600 focus:ring-purple-500 border-gray-300 rounded">
                            <label for="check_support" class="ml-2 text-sm text-gray-700">Check exchange support after creation</label>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Submit Buttons -->
            <div class="flex justify-end space-x-4">
                <a href="{{ route('admin.coins.index') }}" class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500">
                    Cancel
                </a>
                <button type="submit" class="px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-purple-600 hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-purple-500">
                    <i class="ri-add-line mr-2"></i>
                    Create Coin
                </button>
            </div>
        </form>
    </div>

    <script>
        // Image type toggle
        document.querySelectorAll('input[name="image_type"]').forEach(radio => {
            radio.addEventListener('change', function() {
                const urlInput = document.getElementById('url-input');
                const fileInput = document.getElementById('file-input');
                
                if (this.value === 'url') {
                    urlInput.classList.remove('hidden');
                    fileInput.classList.add('hidden');
                } else {
                    urlInput.classList.add('hidden');
                    fileInput.classList.remove('hidden');
                }
            });
        });

        // Manual price toggle
        document.getElementById('use_manual_price').addEventListener('change', function() {
            const manualPriceInput = document.getElementById('manual-price-input');
            if (this.checked) {
                manualPriceInput.classList.remove('hidden');
            } else {
                manualPriceInput.classList.add('hidden');
            }
        });

        // Image preview
        function previewImage(input, src) {
            const preview = document.getElementById('image-preview');
            const previewImg = document.getElementById('preview-img');
            
            if (src) {
                previewImg.src = src;
                preview.classList.remove('hidden');
            } else {
                preview.classList.add('hidden');
            }
        }

        // URL image preview
        document.getElementById('image_url').addEventListener('input', function() {
            if (this.value && this.value.match(/\.(jpeg|jpg|gif|png|svg)$/)) {
                previewImage(this, this.value);
            } else {
                document.getElementById('image-preview').classList.add('hidden');
            }
        });

        // File image preview
        document.getElementById('image_file').addEventListener('change', function() {
            const file = this.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    previewImage(this, e.target.result);
                };
                reader.readAsDataURL(file);
            } else {
                document.getElementById('image-preview').classList.add('hidden');
            }
        });

        // Auto-fill display symbol from symbol
        document.getElementById('symbol').addEventListener('input', function() {
            const displaySymbol = document.getElementById('display_symbol');
            if (!displaySymbol.value) {
                displaySymbol.value = this.value;
            }
        });

        // Check manual price on page load
        if (document.getElementById('use_manual_price').checked) {
            document.getElementById('manual-price-input').classList.remove('hidden');
        }
    </script>
</x-admin-layout> 