<x-admin-layout>
    <div class="container px-6 mx-auto">
        <div class="my-6">
            <h2 class="text-2xl font-semibold text-gray-700">Edit Bot</h2>
        </div>
 {{-- Flash Messages --}}
        <x-session-status class="mb-4" :status="session('status')" :errors="$errors" />

        <div class="bg-white rounded-lg shadow-md p-6">
            <form action="{{ route('admin.bots.update', $bot) }}" method="POST">
                @csrf
                @method('PUT')
                
                <div class="grid gap-6">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Name</label>
                        <input type="text" name="name" value="{{ old('name', $bot->name) }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                    </div>

                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Bot Type</label>
                        <input type="text" name="bot_type" value="{{ old('bot_type', $bot->bot_type) }}" required
                               class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                    </div>
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Min Amount</label>
                            <input type="number" name="min_amount" step="0.01" 
                                   value="{{ old('min_amount', $bot->min_amount) }}" required
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Max Amount</label>
                            <input type="number" name="max_amount" step="0.01" 
                                   value="{{ old('max_amount', $bot->max_amount) }}" required
                                   class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                        </div>
                    </div>
<!-- Parameters -->
   <div>
       <label class="block text-sm font-medium text-gray-700 mb-2">Parameters</label>
       <div class="space-y-2 bg-gray-50 p-4 rounded-lg">
           @foreach($botSettings->parameters ?? [] as $key => $value)
               <div class="grid grid-cols-2 gap-4">
                   <input type="text" name="parameters[{{ $key }}]" value="{{ $key }}"
                          class="px-3 py-2 border border-gray-300 rounded-lg" readonly>
                   <input type="text" name="parameters[{{ $key }}]" value="{{ $value }}"
                          class="px-3 py-2 border border-gray-300 rounded-lg">
               </div>
           @endforeach
       </div>
   </div>

   <!-- Supported Pairs -->
   <div>
       <label class="block text-sm font-medium text-gray-700 mb-2">Supported Trading Pairs</label>
       @php
           // Get all active coins (excluding USDT networks as they're the base currency)
           $tradingCoins = \App\Models\Coin::where('is_active', true)
               ->where('symbol', '!=', 'USDT')  // Exclude USDT as it's the quote currency
               ->orderBy('sort_order')
               ->orderBy('symbol')
               ->get();
       @endphp
       
       @foreach($tradingCoins as $coin)
           @php
               $pair = $coin->symbol . '/USDT';
           @endphp
               <div class="flex items-center space-x-2">
                   <input type="checkbox" name="supported_pairs[]" value="{{ $pair }}"
                          {{ in_array($pair, $botSettings->supported_pairs ?? []) ? 'checked' : '' }}
                          class="rounded">
               <div class="flex items-center space-x-2">
                   @if($coin->image_url)
                       <img src="{{ $coin->image_url }}" alt="{{ $coin->symbol }}" class="h-4 w-4">
                   @endif
                   <span>{{ $pair }}</span>
                   @if($coin->network)
                       <span class="text-xs text-gray-500">({{ $coin->network }})</span>
                   @endif
               </div>
               </div>
           @endforeach
       
       @if($tradingCoins->isEmpty())
           <div class="text-gray-500 text-sm">
               No active cryptocurrencies found for trading pairs.
               <a href="{{ route('admin.coins.index') }}" class="text-blue-600 hover:text-blue-700">
                   Manage Cryptocurrencies →
               </a>
       </div>
       @endif
   </div>

                    <label class="block text-sm font-medium text-gray-700 mb-2">Duration Options</label>
<div class="space-y-2">
   @foreach(['5m', '10m', '15m', '30m', '1h', '4h', '12h', '24h', '3d', '7d', '30d'] as $duration)
       <div class="flex items-center space-x-2">
           <input type="checkbox" name="duration_options[]" value="{{ $duration }}"
                  {{ in_array($duration, $botSettings->duration_options ?? []) ? 'checked' : '' }}
                  class="rounded">
           <span>{{ str_replace(['m', 'h', 'd'], [' Minutes', ' Hours', ' Days'], $duration) }}</span>
       </div>
   @endforeach
</div>
                </div>

                <div class="mt-6 flex justify-end space-x-3">
                    <a href="{{ route('admin.bots.index') }}" 
                       class="px-4 py-2 text-sm font-medium text-gray-700 bg-gray-100 rounded-lg hover:bg-gray-200">
                        Cancel
                    </a>
                    <button type="submit"
                            class="px-4 py-2 text-sm font-medium text-white bg-purple-600 rounded-lg hover:bg-purple-700">
                        Update Bot
                    </button>
                </div>
            </form>
        </div>
    </div>
</x-admin-layout>