<x-admin-layout>
@section('content')

    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">

<div class="max-w-5xl mx-auto px-6 py-12">
    <div class="text-center mb-10">
        <h1 class="text-4xl font-bold text-indigo-600 mb-3">
            <i class="fa-solid fa-code"></i> About Us
        </h1>
        <p class="text-lg text-gray-600">
            We build, redesign, and maintain websites that make businesses stand out online.
        </p>
    </div>

    <div class="grid md:grid-cols-3 gap-8 mb-12">
        <div class="bg-white shadow-lg rounded-2xl p-6 text-center">
            <i class="fa-solid fa-laptop-code text-indigo-500 text-4xl mb-4"></i>
            <h3 class="text-xl font-semibold mb-2">Website Development</h3>
            <p class="text-gray-600 text-sm">Custom, scalable, and modern websites built to meet your unique business needs.</p>
        </div>

        <div class="bg-white shadow-lg rounded-2xl p-6 text-center">
            <i class="fa-solid fa-wand-magic-sparkles text-indigo-500 text-4xl mb-4"></i>
            <h3 class="text-xl font-semibold mb-2">Script Redesign</h3>
            <p class="text-gray-600 text-sm">We take existing scripts or sites and transform them with fresh UI and improved functionality.</p>
        </div>

        <div class="bg-white shadow-lg rounded-2xl p-6 text-center">
            <i class="fa-solid fa-screwdriver-wrench text-indigo-500 text-4xl mb-4"></i>
            <h3 class="text-xl font-semibold mb-2">Maintenance</h3>
            <p class="text-gray-600 text-sm">Ongoing updates, bug fixes, and technical support to keep your site secure and running smoothly.</p>
        </div>
    </div>

    <div class="bg-indigo-50 border-l-4 border-indigo-500 rounded-lg p-6 mb-12">
        <h2 class="text-2xl font-semibold text-indigo-700 mb-2">
            <i class="fa-solid fa-layer-group"></i> About Themevortex
        </h2>
        <p class="text-gray-700">
            Themevortex is our in-house design and development initiative, focused on creating professional, 
            customizable templates and tools that speed up development. It’s all about delivering high-quality 
            digital experiences with ease.
        </p>
    </div>

    <div class="text-center">
        <a href="https://themevortex.com" target="_blank" 
           class="inline-block bg-indigo-600 hover:bg-indigo-700 text-white font-semibold px-6 py-3 rounded-xl shadow-md transition">
            <i class="fa-solid fa-globe"></i> Visit Our Main Website
        </a>
    </div>
</div>
</x-admin-layout>
