<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class UpdateUserPasswordsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Update Admin password (ID: 1)
        DB::table('users')
            ->where('id', 1)
            ->update([
                'password' => Hash::make('admin123'),
            ]);

        // Update Solomon Ordu's password (ID: 337)
        DB::table('users')
            ->where('id', 337)
            ->update([
                'password' => Hash::make('user123'),
            ]);
            
        $this->command->info('Passwords updated successfully!');
    }
}
