<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\StakingPlan;
use App\Models\Coin;

class StakingPlanSeeder extends Seeder
{
    public function run()
    {
        $btc = Coin::where('symbol', 'BTC')->first();
        $eth = Coin::where('symbol', 'ETH')->first();
        $xrp = Coin::where('symbol', 'XRP')->first();

        if ($btc) {
            StakingPlan::create([
                'name' => 'Quantum Flex 30',
                'description' => 'Daily 3% | 30-Day Lock',
                'min_amount' => 0.01,
                'max_amount' => 2,
                'return_of_interest' => 3.0,
                'interest_type' => 'daily',
                'lock_duration' => 30,
                'coin_id' => $btc->id,
                'is_active' => true,
            ]);
        }
        if ($eth) {
            StakingPlan::create([
                'name' => 'ETH Yield 60',
                'description' => 'Daily 4.5% | 60-Day Lock',
                'min_amount' => 0.5,
                'max_amount' => 20,
                'return_of_interest' => 4.5,
                'interest_type' => 'daily',
                'lock_duration' => 60,
                'coin_id' => $eth->id,
                'is_active' => true,
            ]);
        }
        if ($xrp) {
            StakingPlan::create([
                'name' => 'XRP Power 15',
                'description' => 'Weekly 10% | 15-Day Lock',
                'min_amount' => 100,
                'max_amount' => 10000,
                'return_of_interest' => 10.0,
                'interest_type' => 'weekly',
                'lock_duration' => 15,
                'coin_id' => $xrp->id,
                'is_active' => true,
            ]);
        }
    }
} 