<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class AddStakeTypeToTransactionsTable extends Migration
{
    public function up()
    {
        // Modify the enum to add 'stake' as a valid type
        DB::statement("ALTER TABLE transactions MODIFY COLUMN type ENUM('deposit','withdrawal','swap','funding','refund','stake') NOT NULL");
    }

    public function down()
    {
        // Remove 'stake' from the enum (revert to original)
        DB::statement("ALTER TABLE transactions MODIFY COLUMN type ENUM('deposit','withdrawal','swap','funding','refund') NOT NULL");
    }
} 