<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('user_stakes', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users');
            $table->foreignId('staking_plan_id')->constrained('staking_plans');
            $table->decimal('amount', 18, 8);
            $table->timestamp('start_time');
            $table->timestamp('end_time');
            $table->enum('status', ['active', 'completed', 'withdrawn', 'cancelled'])->default('active');
            $table->decimal('profit_earned', 18, 8)->default(0);
            $table->json('metadata')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('user_stakes');
    }
}; 