<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('staking_plans', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->decimal('min_amount', 18, 8);
            $table->decimal('max_amount', 18, 8);
            $table->decimal('return_of_interest', 8, 4); // e.g. 3.0 for 3%
            $table->enum('interest_type', ['hourly', 'daily', 'weekly']);
            $table->integer('lock_duration'); // in days
            $table->foreignId('coin_id')->constrained('coins');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('staking_plans');
    }
}; 