<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('cards', function (Blueprint $table) {
            // Make crypto_asset_id nullable since we're moving to the new coin system
            $table->foreignId('crypto_asset_id')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('cards', function (Blueprint $table) {
            // Revert crypto_asset_id back to not nullable
            $table->foreignId('crypto_asset_id')->nullable(false)->change();
        });
    }
};
