<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Make legacy fields nullable since we're using the new coin system
            $table->string('which_crypto')->nullable()->change();
            $table->string('from_crypto')->nullable()->change();
            $table->string('to_crypto')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Revert back to non-nullable (but this might fail if there are null values)
            $table->string('which_crypto')->nullable(false)->change();
            $table->string('from_crypto')->nullable(false)->change();
            $table->string('to_crypto')->nullable(false)->change();
        });
    }
};
