<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Make cryptoasset_id nullable for backward compatibility
            $table->unsignedBigInteger('cryptoasset_id')->nullable()->change();
            
            // Add new coin system fields
            $table->unsignedBigInteger('from_coin_id')->nullable()->after('cryptoasset_id');
            $table->unsignedBigInteger('to_coin_id')->nullable()->after('from_coin_id');
            
            // Add foreign key constraints
            $table->foreign('from_coin_id')->references('id')->on('coins')->onDelete('set null');
            $table->foreign('to_coin_id')->references('id')->on('coins')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // Drop foreign keys first
            $table->dropForeign(['from_coin_id']);
            $table->dropForeign(['to_coin_id']);
            
            // Drop the new columns
            $table->dropColumn(['from_coin_id', 'to_coin_id']);
            
            // Make cryptoasset_id required again
            $table->unsignedBigInteger('cryptoasset_id')->nullable(false)->change();
        });
    }
};
