<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('exchange_configs', function (Blueprint $table) {
            $table->id();
            
            // Exchange identification
            $table->string('name', 50)->unique()->comment('Exchange name (kucoin, huobi, gateio)');
            $table->string('api_url')->comment('API endpoint URL');
            
            // Configuration
            $table->boolean('is_active')->default(true)->comment('Whether to use this exchange');
            $table->integer('priority')->default(0)->comment('Priority order (higher = checked first)');
            $table->string('supported_pairs_suffix', 20)->default('USDT')->comment('Trading pair suffix to look for');
            
            // Rate limiting and performance
            $table->integer('rate_limit_per_minute')->default(60)->comment('API rate limit per minute');
            $table->integer('timeout_seconds')->default(5)->comment('Request timeout in seconds');
            
            // API response configuration (JSON stored for flexibility)
            $table->json('response_config')->nullable()->comment('API response parsing configuration');
            
            $table->timestamps();
            
            // Indexes
            $table->index('is_active');
            $table->index('priority');
            $table->index(['is_active', 'priority']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('exchange_configs');
    }
};
