<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_coin_balances', function (Blueprint $table) {
            $table->id();
            
            // Foreign keys
            $table->unsignedBigInteger('user_id')->comment('Reference to users table');
            $table->unsignedBigInteger('coin_id')->comment('Reference to coins table');
            
            // Balance and address information
            $table->decimal('balance', 18, 8)->default(0)->comment('User balance for this coin');
            $table->string('address')->nullable()->comment('User wallet address for this coin');
            
            // User preferences
            $table->boolean('is_enabled')->default(false)->comment('User has enabled this coin');
            
            // Custom fee overrides (null means use coin default)
            $table->decimal('custom_fee', 18, 8)->nullable()->comment('Custom network fee override');
            $table->decimal('custom_swap_fee', 18, 8)->nullable()->comment('Custom swap fee override');
            
            $table->timestamps();
            
            // Constraints and indexes
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('coin_id')->references('id')->on('coins')->onDelete('cascade');
            
            $table->unique(['user_id', 'coin_id'], 'user_coin_balances_user_coin_unique');
            $table->index('user_id');
            $table->index('coin_id');
            $table->index('is_enabled');
            $table->index(['user_id', 'is_enabled']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_coin_balances');
    }
};
