<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('coins', function (Blueprint $table) {
            $table->id();
            
            // Basic coin information
            $table->string('symbol', 20)->comment('Coin symbol (BTC, ETH, USDT)');
            $table->string('name', 100)->comment('Full coin name (Bitcoin, Ethereum, Tether)');
            $table->string('network', 50)->nullable()->comment('Network type (TRC20, ERC20, BEP20, null for native)');
            $table->string('display_symbol', 50)->comment('Symbol to display in UI (BTC, USDT-TRC20)');
            $table->string('price_symbol', 50)->comment('Symbol for price API lookup (bitcoin, tether)');
            
            // Visual representation
            $table->string('image')->nullable()->comment('Image file path or URL');
            
            // Configuration
            $table->integer('decimals')->default(8)->comment('Decimal places for display');
            $table->decimal('default_fee', 18, 8)->default(0)->comment('Default network fee');
            $table->decimal('default_swap_fee', 18, 8)->default(0)->comment('Default swap fee');
            $table->text('address_validation_regex')->nullable()->comment('Regex for address validation');
            $table->integer('sort_order')->default(0)->comment('Display sort order');
            $table->boolean('is_active')->default(true)->comment('Admin can enable/disable');
            
            // Exchange support tracking
            $table->json('supported_exchanges')->nullable()->comment('Exchange support data');
            $table->decimal('manual_price_usd', 18, 8)->nullable()->comment('Manual price override');
            $table->boolean('use_manual_price')->default(false)->comment('Use manual price instead of API');
            $table->timestamp('last_price_check')->nullable()->comment('Last exchange support check');
            $table->enum('price_check_status', ['supported', 'unsupported', 'manual', 'checking'])->default('checking')->comment('Price data availability status');
            
            $table->timestamps();
            
            // Indexes
            $table->unique(['symbol', 'network'], 'coins_symbol_network_unique');
            $table->index('is_active');
            $table->index('sort_order');
            $table->index('price_symbol');
            $table->index('price_check_status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('coins');
    }
};
