<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserStake extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', 'staking_plan_id', 'amount', 'start_time', 'end_time', 'next_payout', 'status', 'profit_earned', 'metadata'
    ];

    protected $dates = [
        'start_time', 'end_time', 'next_payout'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function stakingPlan()
    {
        return $this->belongsTo(StakingPlan::class);
    }

    public function coin()
    {
        return $this->stakingPlan->coin();
    }
} 