<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class StakingPlan extends Model
{
    use HasFactory;

    protected $fillable = [
        'name', 'description', 'min_amount', 'max_amount', 'return_of_interest', 'interest_type', 'lock_duration', 'coin_id', 'is_active'
    ];

    public function coin()
    {
        return $this->belongsTo(Coin::class);
    }

    public function userStakes()
    {
        return $this->hasMany(UserStake::class);
    }
} 