<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Contracts\Queue\ShouldQueue;
use App\Models\UserStake;

class StakingStartedEmail extends Mailable implements ShouldQueue
{
    use Queueable, SerializesModels;

    public $userStake;

    public function __construct(UserStake $userStake)
    {
        $this->userStake = $userStake;
        $this->userStake->start_time = \Illuminate\Support\Carbon::parse($userStake->start_time);
        $this->userStake->end_time = \Illuminate\Support\Carbon::parse($userStake->end_time);
    }

    public function build()
    {
        return $this->subject('Staking Started: ' . $this->userStake->stakingPlan->name)
            ->markdown('emails.staking.started')
            ->with([
                'userStake' => $this->userStake,
                'stakingPlan' => $this->userStake->stakingPlan,
                'user' => $this->userStake->user,
            ]);
    }
} 